/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.util;

import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;

public class TimeUtils {
    private static final Logger logger = TableClientLoggerFactory.getLogger(TimeUtils.class);

    public static long getCurrentTimeMs() {
        return System.currentTimeMillis();
    }

    public static long getCurrentTimeUs() {
        return System.currentTimeMillis() * 1000L;
    }

    public static long getNanoTimeUs() {
        return System.nanoTime() / 1000L;
    }

    public static long getNanoTimeNs() {
        return System.nanoTime();
    }

    public static void sleep(long timeMs) {
        try {
            Thread.sleep(timeMs);
        }
        catch (InterruptedException e) {
            logger.error(e.toString());
        }
    }

    public static String formatTimeUsToDate(long timeUS) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeUS / 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(c.getTime());
    }

    public static String formatTimeMsToDate(long timeMS) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeMS);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(c.getTime());
    }

    public static String getTime(String format) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(c.getTime());
    }

    public static Timestamp strToTimestamp(String str) {
        Timestamp ts;
        block2: {
            ts = null;
            try {
                ts = Timestamp.valueOf(str);
            }
            catch (IllegalArgumentException e) {
                logger.warn(String.format("fail to convert str to timestamp, str=%s, errMsg=}%s", str, e.getMessage()), (Throwable)e);
                Date date = TimeUtils.strToUtilDate(str);
                if (null == date) break block2;
                ts = new Timestamp(date.getTime());
            }
        }
        return ts;
    }

    public static java.sql.Date strToDate(String str) {
        java.sql.Date sqlDate = null;
        Date utilDate = TimeUtils.strToUtilDate(str);
        if (utilDate != null) {
            sqlDate = new java.sql.Date(utilDate.getTime());
        } else {
            Timestamp ts = TimeUtils.strToTimestamp(str);
            if (ts != null) {
                sqlDate = new java.sql.Date(ts.getTime());
            }
        }
        return sqlDate;
    }

    private static Date strToUtilDate(String str) {
        Date utilDate = null;
        str = str.trim();
        try {
            SimpleDateFormat dateFormat = null;
            switch (str.length()) {
                case 8: {
                    dateFormat = new SimpleDateFormat("yyyyMMdd");
                    break;
                }
                case 10: {
                    dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    break;
                }
                case 14: {
                    dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    break;
                }
            }
            if (dateFormat != null) {
                utilDate = dateFormat.parse(str);
            }
        }
        catch (ParseException e) {
            logger.warn(String.format("failed to cast obj, str=%s, cause=%s", str, e.getCause()), (Throwable)e);
        }
        return utilDate;
    }
}

