/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.BasePrepareStatement;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.OceanBaseParameterMetaData;
import com.oceanbase.jdbc.internal.com.read.dao.Results;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.output.StandardPacketOutputStream;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.dao.ClientPrepareResult;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Array;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JDBC4PreparedStatement
extends BasePrepareStatement {
    private static final Logger logger = LoggerFactory.getLogger(JDBC4PreparedStatement.class);
    private ParameterHolder[] parameters;
    private final List<ParameterHolder[]> parametersList = new ArrayList<ParameterHolder[]>();
    private ClientPrepareResult prepareResult;
    private ResultSetMetaData resultSetMetaData;
    private ParameterMetaData parameterMetaData;

    public JDBC4PreparedStatement(OceanBaseConnection connection, String sql, int resultSetScrollType, int resultSetConcurrency, int autoGeneratedKeys, ExceptionFactory exceptionFactory) throws SQLException {
        super(connection, resultSetScrollType, resultSetConcurrency, autoGeneratedKeys, exceptionFactory);
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        this.originalSql = sql;
        this.simpleSql = Utils.trimSQLString(this.originalSql, this.protocol.noBackslashEscapes(), this.protocol.isOracleMode(), false);
        this.sqlType = Utils.getStatementType(this.simpleSql);
        this.actualSql = this.originalSql;
        if (this.options.rewriteBatchedStatements) {
            if (!this.options.useServerPrepStmts && this.protocol.isOracleMode() && this.options.supportNameBinding) {
                this.actualSql = Utils.trimSQLString(this.originalSql, this.protocol.noBackslashEscapes(), this.protocol.isOracleMode(), true);
            }
            this.prepareResult = ClientPrepareResult.rewritableParts(this.actualSql, this.protocol.noBackslashEscapes(), this.protocol.isOracleMode(), this.protocol.getEncoding());
        } else {
            this.prepareResult = ClientPrepareResult.parameterParts(this.actualSql, this.protocol.noBackslashEscapes(), this.protocol.isOracleMode(), this.protocol.getEncoding());
        }
        this.parameterCount = this.prepareResult.getParamCount();
        this.parameters = new ParameterHolder[this.parameterCount];
        if (this.protocol != null) {
            this.protocol.endCallInterface("JDBC4PreparedStatement");
        }
    }

    @Override
    public JDBC4PreparedStatement clone(OceanBaseConnection connection) throws CloneNotSupportedException {
        JDBC4PreparedStatement clone = (JDBC4PreparedStatement)super.clone(connection);
        clone.actualSql = this.actualSql;
        clone.prepareResult = this.prepareResult;
        clone.parameterCount = this.prepareResult.getParamCount();
        clone.parameters = new ParameterHolder[this.parameterCount];
        clone.resultSetMetaData = this.resultSetMetaData;
        clone.parameterMetaData = this.parameterMetaData;
        return clone;
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal(this.getFetchSize());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.execute() && this.results != null && this.results.getResultSet() != null) {
            return this.results.getResultSet();
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            return 0;
        }
        return this.getUpdateCount();
    }

    /*
     * Loose catch block
     */
    @Override
    protected boolean executeInternal(int fetchSize) throws SQLException {
        int i;
        for (i = 0; i < this.parameterCount; ++i) {
            if (this.parameters[i] != null) continue;
            logger.error("Parameter at position {} is not set", (Object)(i + 1));
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("Parameter at position " + (i + 1) + " is not set", "07004");
        }
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        this.lock.lock();
        try {
            lockLogger.debug("JDBC4PreparedStatement.executeInternal locked");
            try {
                this.executeQueryPrologue(false);
                this.results = new Results(this, fetchSize, false, 1, false, this.resultSetScrollType, this.resultSetConcurrency, this.autoGeneratedKeys, this.protocol.getAutoIncrementIncrement(), this.actualSql, this.parameters);
                if (this.queryTimeout != 0 && this.canUseServerTimeout) {
                    this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameters, this.queryTimeout);
                } else {
                    this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameters);
                }
                this.results.commandEnd();
                i = this.results.getResultSet() != null ? 1 : 0;
                return i != 0;
            }
            catch (SQLException exception) {
                if (this.results != null) {
                    this.results.commandEnd();
                }
                throw this.executeExceptionEpilogue(exception);
            }
            finally {
                this.executeEpilogue();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
            lockLogger.debug("JDBC4PreparedStatement.executeInternal unlocked");
            if (this.protocol != null) {
                this.protocol.endCallInterface("JDBC4PreparedStatement.executeInternal");
            }
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.lock.lock();
        try {
            ParameterHolder[] holder = new ParameterHolder[this.parameterCount];
            for (int i = 0; i < holder.length; ++i) {
                holder[i] = this.parameters[i];
                if (holder[i] != null) continue;
                logger.error("You need to set exactly " + this.parameterCount + " parameters on the prepared statement");
                throw this.exceptionFactory.raiseStatementError(this.connection, this).create("You need to set exactly " + this.parameterCount + " parameters on the prepared statement");
            }
            this.parametersList.add(holder);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        super.addBatch(sql);
    }

    @Override
    public void clearBatch() {
        this.parametersList.clear();
        this.hasLongData = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int i;
        this.checkClose();
        int[] retBatchQuery = new int[]{};
        int[] retBatch = new int[]{};
        int size = this.parametersList.size();
        if (size != 0) {
            this.lock.lock();
            try {
                lockLogger.debug("JDBC4PreparedStatement.executeBatch locked");
                try {
                    this.executeInternalBatch(size);
                    this.results.commandEnd();
                    retBatch = this.results.getCmdInformation().getUpdateCounts();
                }
                catch (SQLException sqle) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    sqle.printStackTrace(pw);
                    logger.error("--------------------------------------------------------------------------\n" + this.actualSql + "\n" + sw + "\n--------------------------------------------------------------------------\n");
                    try {
                        throw this.executeBatchExceptionEpilogue(sqle, size);
                    }
                    catch (NullPointerException e) {
                        e.initCause(sqle);
                        throw e;
                    }
                }
                finally {
                    this.executeBatchEpilogue();
                }
            }
            finally {
                this.lock.unlock();
                lockLogger.debug("JDBC4PreparedStatement.executeBatch unlocked");
            }
        }
        if (this.batchQueries != null && this.batchQueries.size() > 0) {
            retBatchQuery = super.executeBatch();
        }
        int[] ret = new int[retBatch.length + retBatchQuery.length];
        int cur = 0;
        for (i = 0; i < retBatch.length; ++i) {
            ret[cur++] = retBatch[i];
        }
        for (i = 0; i < retBatchQuery.length; ++i) {
            ret[cur++] = retBatchQuery[i];
        }
        return ret;
    }

    public int[] getServerUpdateCounts() {
        if (this.results != null && this.results.getCmdInformation() != null) {
            return this.results.getCmdInformation().getServerUpdateCounts();
        }
        return new int[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        int i;
        this.checkClose();
        long[] retBatchQuery = new long[]{};
        long[] retBatch = new long[]{};
        int size = this.parametersList.size();
        if (size == 0) {
            retBatch = new long[]{};
        } else {
            this.lock.lock();
            try {
                lockLogger.debug("JDBC4PreparedStatement.executeLargeBatch locked");
                try {
                    this.executeInternalBatch(size);
                    this.results.commandEnd();
                    retBatch = this.results.getCmdInformation().getLargeUpdateCounts();
                }
                catch (SQLException sqle) {
                    throw this.executeBatchExceptionEpilogue(sqle, size);
                }
                finally {
                    this.executeBatchEpilogue();
                }
            }
            finally {
                this.lock.unlock();
                lockLogger.debug("JDBC4PreparedStatement.executeLargeBatch unlocked");
            }
        }
        if (this.batchQueries != null && this.batchQueries.size() > 0) {
            retBatchQuery = super.executeLargeBatch();
        }
        long[] ret = new long[retBatch.length + retBatchQuery.length];
        int cur = 0;
        for (i = 0; i < retBatch.length; ++i) {
            ret[cur++] = retBatch[i];
        }
        for (i = 0; i < retBatchQuery.length; ++i) {
            ret[cur++] = retBatchQuery[i];
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInternalBatch(int size) throws SQLException {
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        try {
            this.executeQueryPrologue(true);
            this.results = new Results(this, 0, true, size, false, this.resultSetScrollType, this.resultSetConcurrency, this.autoGeneratedKeys, this.protocol.getAutoIncrementIncrement(), null, null);
            if (this.protocol.executeBatchClient(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parametersList, this.hasLongData)) {
                return;
            }
            SQLException exception = null;
            if (this.queryTimeout > 0) {
                for (int batchQueriesCount = 0; batchQueriesCount < size; ++batchQueriesCount) {
                    this.protocol.stopIfInterrupted();
                    try {
                        this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parametersList.get(batchQueriesCount));
                        continue;
                    }
                    catch (SQLException e) {
                        if (this.options.continueBatchOnError) {
                            exception = e;
                            continue;
                        }
                        throw e;
                    }
                }
            } else {
                for (int batchQueriesCount = 0; batchQueriesCount < size; ++batchQueriesCount) {
                    try {
                        this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parametersList.get(batchQueriesCount));
                        continue;
                    }
                    catch (SQLException e) {
                        if (this.options.continueBatchOnError) {
                            exception = e;
                            continue;
                        }
                        throw e;
                    }
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            if (this.protocol != null) {
                this.protocol.endCallInterface("JDBC4PreparedStatement.executeInternalBatch");
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClose();
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        if (this.resultSetMetaData == null) {
            this.loadParametersData();
        }
        return this.resultSetMetaData;
    }

    @Override
    public void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        if (parameterIndex < 1 || parameterIndex >= this.parameterCount + 1) {
            String error = "Could not set parameter at position " + parameterIndex + " (values was " + holder.toString() + ")\nQuery - conn:" + this.protocol.getServerThreadId() + "(" + (this.protocol.isMasterConnection() ? "M" : "S") + ") ";
            if (this.options.maxQuerySizeToLog > 0) {
                error = error + " - \"";
                error = this.actualSql.length() < this.options.maxQuerySizeToLog ? error + this.actualSql : error + this.actualSql.substring(0, this.options.maxQuerySizeToLog) + "...";
                error = error + "\"";
            } else {
                error = error + " - \"" + this.actualSql + "\"";
            }
            logger.error(error);
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create(error);
        }
        this.parameters[parameterIndex - 1] = holder;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClose();
        if (this.parameterMetaData == null) {
            this.loadParametersData();
        }
        return this.parameterMetaData;
    }

    private void loadParametersData() {
        this.parameterMetaData = new OceanBaseParameterMetaData(null, this.parameterCount, this.options.generateSimpleParameterMetadata);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClose();
        this.parameters = new ParameterHolder[this.parameterCount];
    }

    @Override
    public ParameterHolder[] getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(ParameterHolder[] paramArray) {
        this.parameters = Arrays.copyOf(paramArray, this.parameterCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("sql : '" + this.actualSql + "'");
        sb.append(", parameters : [");
        for (int i = 0; i < this.parameters.length; ++i) {
            ParameterHolder holder = this.parameters[i];
            if (holder == null) {
                sb.append("null");
            } else {
                sb.append(holder.toString());
            }
            if (i == this.parameters.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void setArray(int parameterIndex, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    protected ClientPrepareResult getPrepareResult() {
        return this.prepareResult;
    }

    @Override
    public String asSql() throws SQLException {
        return this.asSql(false);
    }

    public String asSql(boolean quoteStreamsAndUnknowns) throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StandardPacketOutputStream out = new StandardPacketOutputStream(byteArrayOutputStream, this.connection.getServerThreadId(), this.options, this.protocol.getTimeTrace());
        out.setOracleMode(this.protocol.isOracleMode());
        ClientPrepareResult clientPrepareResult = this.prepareResult;
        try {
            int i;
            out.startPacket(0);
            if (clientPrepareResult.isRewriteType()) {
                out.write(clientPrepareResult.getQueryParts().get(0));
                out.write(clientPrepareResult.getQueryParts().get(1));
                for (i = 0; i < clientPrepareResult.getParamCount(); ++i) {
                    this.parameters[i].writeTo(out);
                    out.write(clientPrepareResult.getQueryParts().get(i + 2));
                }
                out.write(clientPrepareResult.getQueryParts().get(clientPrepareResult.getParamCount() + 2));
            } else {
                out.write(clientPrepareResult.getQueryParts().get(0));
                for (i = 0; i < clientPrepareResult.getParamCount(); ++i) {
                    this.parameters[i].writeTo(out);
                    out.write(clientPrepareResult.getQueryParts().get(i + 1));
                }
            }
            out.flush();
        }
        catch (IOException e) {
            throw new SQLException("IOException :" + e.getMessage());
        }
        byte[] b = byteArrayOutputStream.toByteArray();
        byte[] original = Arrays.copyOfRange(b, 4, b.length);
        return new String(original);
    }
}

