/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.http;

import com.paypal.http.Encoder;
import com.paypal.http.Environment;
import com.paypal.http.Headers;
import com.paypal.http.HttpRequest;
import com.paypal.http.HttpResponse;
import com.paypal.http.Injector;
import com.paypal.http.exceptions.HttpException;
import com.paypal.http.internal.TLSSocketFactory;
import com.paypal.http.serializer.StreamUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

public class HttpClient {
    private SSLSocketFactory sslSocketFactory;
    private String userAgent;
    private int connectTimeout;
    private int readTimeout;
    private Environment environment;
    private Encoder encoder;
    List<Injector> mInjectors;

    public HttpClient(Environment environment) {
        this.connectTimeout = this.readTimeout = (int)TimeUnit.SECONDS.toMillis(30L);
        this.userAgent = "Java HTTP/1.1";
        this.mInjectors = new ArrayList<Injector>();
        this.environment = environment;
        this.encoder = new Encoder();
        this.addInjector(this::injectStandardHeaders);
        try {
            this.sslSocketFactory = new TLSSocketFactory();
        }
        catch (SSLException e) {
            this.sslSocketFactory = null;
        }
    }

    protected int getConnectTimeout() {
        return this.connectTimeout;
    }

    protected int getReadTimeout() {
        return this.readTimeout;
    }

    protected SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    protected String getUserAgent() {
        return this.userAgent;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    public void setSSLSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public synchronized void addInjector(Injector injector) {
        if (injector != null) {
            this.mInjectors.add(injector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> HttpResponse<T> execute(HttpRequest<T> request) throws IOException {
        HttpRequest<T> requestCopy = request.copy();
        for (Injector injector : this.mInjectors) {
            injector.inject(requestCopy);
        }
        HttpURLConnection connection = this.getConnection(requestCopy);
        try {
            HttpResponse<T> httpResponse = this.parseResponse(connection, requestCopy.responseClass());
            return httpResponse;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void applyHeadersFromRequest(HttpURLConnection connection, HttpRequest request) {
        for (String key : request.headers()) {
            connection.setRequestProperty(key, request.headers().header(key));
        }
    }

    HttpURLConnection getConnection(HttpRequest request) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.environment.baseUrl() + request.path()).openConnection();
        if (connection instanceof HttpsURLConnection) {
            if (this.sslSocketFactory == null) {
                String message = "SSLSocketFactory was not set or failed to initialize";
                System.out.println(message);
                throw new SSLException(message);
            }
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.getSSLSocketFactory());
        }
        connection.setReadTimeout(this.getReadTimeout());
        connection.setConnectTimeout(this.getConnectTimeout());
        this.setRequestVerb(request.verb(), connection);
        if (request.requestBody() != null) {
            connection.setDoOutput(true);
            byte[] data = this.encoder.serializeRequest(request);
            this.applyHeadersFromRequest(connection, request);
            StreamUtils.writeOutputStream(connection.getOutputStream(), data);
        } else {
            this.applyHeadersFromRequest(connection, request);
        }
        return connection;
    }

    private void setRequestVerb(String verb, HttpURLConnection connection) {
        try {
            connection.setRequestMethod(verb.toUpperCase());
        }
        catch (ProtocolException ignored) {
            try {
                Field delegateField = connection.getClass().getDeclaredField("delegate");
                delegateField.setAccessible(true);
                HttpURLConnection delegateConnection = (HttpURLConnection)delegateField.get(connection);
                this.setRequestVerb(verb, delegateConnection);
            }
            catch (NoSuchFieldException e) {
                Field methodField = null;
                Class<?> connectionClass = connection.getClass();
                while (methodField == null) {
                    try {
                        methodField = connectionClass.getDeclaredField("method");
                        methodField.setAccessible(true);
                        methodField.set(connection, "PATCH");
                    }
                    catch (IllegalAccessException | NoSuchFieldException _ignored) {
                        connectionClass = connectionClass.getSuperclass();
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    Headers parseResponseHeaders(URLConnection connection) {
        Headers headers = new Headers();
        for (String key : connection.getHeaderFields().keySet()) {
            headers.header(key, connection.getHeaderField(key));
        }
        return headers;
    }

    private <T> HttpResponse<T> parseResponse(HttpURLConnection connection, Class<T> responseClass) throws IOException {
        Headers responseHeaders = this.parseResponseHeaders(connection);
        int statusCode = connection.getResponseCode();
        if (statusCode >= 200 && statusCode <= 206) {
            Object deserializedResponse = null;
            if (!Void.class.isAssignableFrom(responseClass)) {
                deserializedResponse = this.encoder.deserializeResponse(connection.getInputStream(), responseClass, responseHeaders);
            }
            return new HttpResponse<Object>(responseHeaders, statusCode, deserializedResponse);
        }
        String responseBody = this.encoder.deserializeResponse(connection.getErrorStream(), String.class, responseHeaders);
        throw new HttpException(responseBody, statusCode, responseHeaders);
    }

    private void injectStandardHeaders(HttpRequest request) throws IOException {
        request.headers().headerIfNotPresent("user-agent", this.getUserAgent());
    }
}

