/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for CaptureAuthorizedPaymentInput type.
 */
public class CaptureAuthorizedPaymentInput {
    private String authorizationId;
    private String contentType;
    private String paypalMockResponse;
    private String paypalRequestId;
    private String prefer;
    private String paypalAuthAssertion;
    private CaptureRequest body;

    /**
     * Default constructor.
     */
    public CaptureAuthorizedPaymentInput() {
        contentType = "application/json";
        prefer = "return=minimal";
    }

    /**
     * Initialization constructor.
     * @param  authorizationId  String value for authorizationId.
     * @param  contentType  String value for contentType.
     * @param  paypalMockResponse  String value for paypalMockResponse.
     * @param  paypalRequestId  String value for paypalRequestId.
     * @param  prefer  String value for prefer.
     * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
     * @param  body  CaptureRequest value for body.
     */
    public CaptureAuthorizedPaymentInput(
            String authorizationId,
            String contentType,
            String paypalMockResponse,
            String paypalRequestId,
            String prefer,
            String paypalAuthAssertion,
            CaptureRequest body) {
        this.authorizationId = authorizationId;
        this.contentType = contentType;
        this.paypalMockResponse = paypalMockResponse;
        this.paypalRequestId = paypalRequestId;
        this.prefer = prefer;
        this.paypalAuthAssertion = paypalAuthAssertion;
        this.body = body;
    }

    /**
     * Getter for AuthorizationId.
     * The PayPal-generated ID for the authorized payment to capture.
     * @return Returns the String
     */
    @JsonGetter("authorization_id")
    public String getAuthorizationId() {
        return authorizationId;
    }

    /**
     * Setter for AuthorizationId.
     * The PayPal-generated ID for the authorized payment to capture.
     * @param authorizationId Value for String
     */
    @JsonSetter("authorization_id")
    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    /**
     * Getter for ContentType.
     * @return Returns the String
     */
    @JsonGetter("Content-Type")
    public String getContentType() {
        return contentType;
    }

    /**
     * Setter for ContentType.
     * @param contentType Value for String
     */
    @JsonSetter("Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    /**
     * Getter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Mock-Response")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalMockResponse() {
        return paypalMockResponse;
    }

    /**
     * Setter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @param paypalMockResponse Value for String
     */
    @JsonSetter("PayPal-Mock-Response")
    public void setPaypalMockResponse(String paypalMockResponse) {
        this.paypalMockResponse = paypalMockResponse;
    }

    /**
     * Getter for PaypalRequestId.
     * The server stores keys for 45 days.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Request-Id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalRequestId() {
        return paypalRequestId;
    }

    /**
     * Setter for PaypalRequestId.
     * The server stores keys for 45 days.
     * @param paypalRequestId Value for String
     */
    @JsonSetter("PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    /**
     * Getter for Prefer.
     * The preferred server response upon successful completion of the request. Value is:
     * return=minimal. The server returns a minimal response to optimize communication between the
     * API caller and the server. A minimal response includes the id, status and HATEOAS links.
     * return=representation. The server returns a complete resource representation, including the
     * current state of the resource.
     * @return Returns the String
     */
    @JsonGetter("Prefer")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return prefer;
    }

    /**
     * Setter for Prefer.
     * The preferred server response upon successful completion of the request. Value is:
     * return=minimal. The server returns a minimal response to optimize communication between the
     * API caller and the server. A minimal response includes the id, status and HATEOAS links.
     * return=representation. The server returns a complete resource representation, including the
     * current state of the resource.
     * @param prefer Value for String
     */
    @JsonSetter("Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    /**
     * Getter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see
     * [PayPal-Auth-Assertion](/docs/api/reference/api-requests/#paypal-auth-assertion). Note:For
     * three party transactions in which a partner is managing the API calls on behalf of a
     * merchant, the partner must identify the merchant using either a PayPal-Auth-Assertion header
     * or an access token with target_subject.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Auth-Assertion")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return paypalAuthAssertion;
    }

    /**
     * Setter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see
     * [PayPal-Auth-Assertion](/docs/api/reference/api-requests/#paypal-auth-assertion). Note:For
     * three party transactions in which a partner is managing the API calls on behalf of a
     * merchant, the partner must identify the merchant using either a PayPal-Auth-Assertion header
     * or an access token with target_subject.
     * @param paypalAuthAssertion Value for String
     */
    @JsonSetter("PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    /**
     * Getter for Body.
     * @return Returns the CaptureRequest
     */
    @JsonGetter("body")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CaptureRequest getBody() {
        return body;
    }

    /**
     * Setter for Body.
     * @param body Value for CaptureRequest
     */
    @JsonSetter("body")
    public void setBody(CaptureRequest body) {
        this.body = body;
    }

    /**
     * Converts this CaptureAuthorizedPaymentInput into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "CaptureAuthorizedPaymentInput [" + "authorizationId=" + authorizationId
                + ", contentType=" + contentType + ", paypalMockResponse=" + paypalMockResponse
                + ", paypalRequestId=" + paypalRequestId + ", prefer=" + prefer
                + ", paypalAuthAssertion=" + paypalAuthAssertion + ", body=" + body + "]";
    }

    /**
     * Builds a new {@link CaptureAuthorizedPaymentInput.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link CaptureAuthorizedPaymentInput.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(authorizationId, contentType)
                .paypalMockResponse(getPaypalMockResponse())
                .paypalRequestId(getPaypalRequestId())
                .prefer(getPrefer())
                .paypalAuthAssertion(getPaypalAuthAssertion())
                .body(getBody());
        return builder;
    }

    /**
     * Class to build instances of {@link CaptureAuthorizedPaymentInput}.
     */
    public static class Builder {
        private String authorizationId;
        private String contentType = "application/json";
        private String paypalMockResponse;
        private String paypalRequestId;
        private String prefer = "return=minimal";
        private String paypalAuthAssertion;
        private CaptureRequest body;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  authorizationId  String value for authorizationId.
         * @param  contentType  String value for contentType.
         */
        public Builder(String authorizationId, String contentType) {
            this.authorizationId = authorizationId;
            this.contentType = contentType;
        }

        /**
         * Setter for authorizationId.
         * @param  authorizationId  String value for authorizationId.
         * @return Builder
         */
        public Builder authorizationId(String authorizationId) {
            this.authorizationId = authorizationId;
            return this;
        }

        /**
         * Setter for contentType.
         * @param  contentType  String value for contentType.
         * @return Builder
         */
        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Setter for paypalMockResponse.
         * @param  paypalMockResponse  String value for paypalMockResponse.
         * @return Builder
         */
        public Builder paypalMockResponse(String paypalMockResponse) {
            this.paypalMockResponse = paypalMockResponse;
            return this;
        }

        /**
         * Setter for paypalRequestId.
         * @param  paypalRequestId  String value for paypalRequestId.
         * @return Builder
         */
        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        /**
         * Setter for prefer.
         * @param  prefer  String value for prefer.
         * @return Builder
         */
        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        /**
         * Setter for paypalAuthAssertion.
         * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
         * @return Builder
         */
        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        /**
         * Setter for body.
         * @param  body  CaptureRequest value for body.
         * @return Builder
         */
        public Builder body(CaptureRequest body) {
            this.body = body;
            return this;
        }

        /**
         * Builds a new {@link CaptureAuthorizedPaymentInput} object using the set fields.
         * @return {@link CaptureAuthorizedPaymentInput}
         */
        public CaptureAuthorizedPaymentInput build() {
            return new CaptureAuthorizedPaymentInput(authorizationId, contentType,
                    paypalMockResponse, paypalRequestId, prefer, paypalAuthAssertion, body);
        }
    }
}
