/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for CardVerificationProcessorResponse type.
 */
public class CardVerificationProcessorResponse {
    private AvsCode avsCode;
    private CvvCode cvvCode;

    /**
     * Default constructor.
     */
    public CardVerificationProcessorResponse() {
    }

    /**
     * Initialization constructor.
     * @param  avsCode  AvsCode value for avsCode.
     * @param  cvvCode  CvvCode value for cvvCode.
     */
    public CardVerificationProcessorResponse(
            AvsCode avsCode,
            CvvCode cvvCode) {
        this.avsCode = avsCode;
        this.cvvCode = cvvCode;
    }

    /**
     * Getter for AvsCode.
     * The address verification code for Visa, Discover, Mastercard, or American Express
     * transactions.
     * @return Returns the AvsCode
     */
    @JsonGetter("avs_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public AvsCode getAvsCode() {
        return avsCode;
    }

    /**
     * Setter for AvsCode.
     * The address verification code for Visa, Discover, Mastercard, or American Express
     * transactions.
     * @param avsCode Value for AvsCode
     */
    @JsonSetter("avs_code")
    public void setAvsCode(AvsCode avsCode) {
        this.avsCode = avsCode;
    }

    /**
     * Getter for CvvCode.
     * The card verification value code for for Visa, Discover, Mastercard, or American Express.
     * @return Returns the CvvCode
     */
    @JsonGetter("cvv_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CvvCode getCvvCode() {
        return cvvCode;
    }

    /**
     * Setter for CvvCode.
     * The card verification value code for for Visa, Discover, Mastercard, or American Express.
     * @param cvvCode Value for CvvCode
     */
    @JsonSetter("cvv_code")
    public void setCvvCode(CvvCode cvvCode) {
        this.cvvCode = cvvCode;
    }

    /**
     * Converts this CardVerificationProcessorResponse into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "CardVerificationProcessorResponse [" + "avsCode=" + avsCode + ", cvvCode=" + cvvCode
                + "]";
    }

    /**
     * Builds a new {@link CardVerificationProcessorResponse.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link CardVerificationProcessorResponse.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .avsCode(getAvsCode())
                .cvvCode(getCvvCode());
        return builder;
    }

    /**
     * Class to build instances of {@link CardVerificationProcessorResponse}.
     */
    public static class Builder {
        private AvsCode avsCode;
        private CvvCode cvvCode;



        /**
         * Setter for avsCode.
         * @param  avsCode  AvsCode value for avsCode.
         * @return Builder
         */
        public Builder avsCode(AvsCode avsCode) {
            this.avsCode = avsCode;
            return this;
        }

        /**
         * Setter for cvvCode.
         * @param  cvvCode  CvvCode value for cvvCode.
         * @return Builder
         */
        public Builder cvvCode(CvvCode cvvCode) {
            this.cvvCode = cvvCode;
            return this;
        }

        /**
         * Builds a new {@link CardVerificationProcessorResponse} object using the set fields.
         * @return {@link CardVerificationProcessorResponse}
         */
        public CardVerificationProcessorResponse build() {
            return new CardVerificationProcessorResponse(avsCode, cvvCode);
        }
    }
}
