/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * CheckoutPaymentIntent to be used.
 */
public enum CheckoutPaymentIntent {
    /**
     * The merchant intends to capture payment immediately after the customer makes a payment.
     */
    CAPTURE,

    /**
     * The merchant intends to authorize a payment and place funds on hold after the customer makes a payment. Authorized payments are best captured within three days of authorization but are available to capture for up to 29 days. After the three-day honor period, the original authorized payment expires and you must re-authorize the payment. You must make a separate request to capture payments on demand. This intent is not supported when you have more than one `purchase_unit` within your order.
     */
    AUTHORIZE,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, CheckoutPaymentIntent> valueMap = new TreeMap<>();
    private String value;

    static {
        CAPTURE.value = "CAPTURE";
        AUTHORIZE.value = "AUTHORIZE";
        _UNKNOWN.value = null;

        valueMap.put("CAPTURE", CAPTURE);
        valueMap.put("AUTHORIZE", AUTHORIZE);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static CheckoutPaymentIntent constructFromString(String toConvert) throws IOException {
        CheckoutPaymentIntent enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static CheckoutPaymentIntent fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of CheckoutPaymentIntent values to list of string values.
     * @param toConvert The list of CheckoutPaymentIntent values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<CheckoutPaymentIntent> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (CheckoutPaymentIntent enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 