/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for CreateSetupTokenInput type.
 */
public class CreateSetupTokenInput {
    private String contentType;
    private SetupTokenRequest body;
    private String paypalRequestId;

    /**
     * Default constructor.
     */
    public CreateSetupTokenInput() {
        contentType = "application/json";
    }

    /**
     * Initialization constructor.
     * @param  contentType  String value for contentType.
     * @param  body  SetupTokenRequest value for body.
     * @param  paypalRequestId  String value for paypalRequestId.
     */
    public CreateSetupTokenInput(
            String contentType,
            SetupTokenRequest body,
            String paypalRequestId) {
        this.contentType = contentType;
        this.body = body;
        this.paypalRequestId = paypalRequestId;
    }

    /**
     * Getter for ContentType.
     * @return Returns the String
     */
    @JsonGetter("Content-Type")
    public String getContentType() {
        return contentType;
    }

    /**
     * Setter for ContentType.
     * @param contentType Value for String
     */
    @JsonSetter("Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    /**
     * Getter for Body.
     * Setup Token creation with a instrument type optional financial instrument details and
     * customer_id.
     * @return Returns the SetupTokenRequest
     */
    @JsonGetter("body")
    public SetupTokenRequest getBody() {
        return body;
    }

    /**
     * Setter for Body.
     * Setup Token creation with a instrument type optional financial instrument details and
     * customer_id.
     * @param body Value for SetupTokenRequest
     */
    @JsonSetter("body")
    public void setBody(SetupTokenRequest body) {
        this.body = body;
    }

    /**
     * Getter for PaypalRequestId.
     * The server stores keys for 3 hours.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Request-Id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalRequestId() {
        return paypalRequestId;
    }

    /**
     * Setter for PaypalRequestId.
     * The server stores keys for 3 hours.
     * @param paypalRequestId Value for String
     */
    @JsonSetter("PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    /**
     * Converts this CreateSetupTokenInput into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "CreateSetupTokenInput [" + "contentType=" + contentType + ", body=" + body
                + ", paypalRequestId=" + paypalRequestId + "]";
    }

    /**
     * Builds a new {@link CreateSetupTokenInput.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link CreateSetupTokenInput.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(contentType, body)
                .paypalRequestId(getPaypalRequestId());
        return builder;
    }

    /**
     * Class to build instances of {@link CreateSetupTokenInput}.
     */
    public static class Builder {
        private String contentType = "application/json";
        private SetupTokenRequest body;
        private String paypalRequestId;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  contentType  String value for contentType.
         * @param  body  SetupTokenRequest value for body.
         */
        public Builder(String contentType, SetupTokenRequest body) {
            this.contentType = contentType;
            this.body = body;
        }

        /**
         * Setter for contentType.
         * @param  contentType  String value for contentType.
         * @return Builder
         */
        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Setter for body.
         * @param  body  SetupTokenRequest value for body.
         * @return Builder
         */
        public Builder body(SetupTokenRequest body) {
            this.body = body;
            return this;
        }

        /**
         * Setter for paypalRequestId.
         * @param  paypalRequestId  String value for paypalRequestId.
         * @return Builder
         */
        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        /**
         * Builds a new {@link CreateSetupTokenInput} object using the set fields.
         * @return {@link CreateSetupTokenInput}
         */
        public CreateSetupTokenInput build() {
            return new CreateSetupTokenInput(contentType, body, paypalRequestId);
        }
    }
}
