/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * CvvCode to be used.
 */
public enum CvvCode {
    /**
     * For Visa, Mastercard, Discover, or American Express, error - unrecognized or unknown response.
     */
    CVV_E,

    /**
     * For Visa, Mastercard, Discover, or American Express, invalid or null.
     */
    CVV_I,

    /**
     * For Visa, Mastercard, Discover, or American Express, the CVV2/CSC matches.
     */
    CVV_M,

    /**
     * For Visa, Mastercard, Discover, or American Express, the CVV2/CSC does not match.
     */
    CVV_N,

    /**
     * For Visa, Mastercard, Discover, or American Express, it was not processed.
     */
    CVV_P,

    /**
     * For Visa, Mastercard, Discover, or American Express, the service is not supported.
     */
    CVV_S,

    /**
     * For Visa, Mastercard, Discover, or American Express, unknown - the issuer is not certified.
     */
    CVV_U,

    /**
     * For Visa, Mastercard, Discover, or American Express, no response. For Maestro, the service is not available.
     */
    CVV_X,

    /**
     * For Visa, Mastercard, Discover, or American Express, error.
     */
    ENUM_ALL_OTHERS,

    /**
     * For Maestro, the CVV2 matched.
     */
    CVV_0,

    /**
     * For Maestro, the CVV2 did not match.
     */
    CVV_1,

    /**
     * For Maestro, the merchant has not implemented CVV2 code handling.
     */
    CVV_2,

    /**
     * For Maestro, the merchant has indicated that CVV2 is not present on card.
     */
    CVV_3,

    /**
     * For Maestro, the service is not available.
     */
    CVV_4,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, CvvCode> valueMap = new TreeMap<>();
    private String value;

    static {
        CVV_E.value = "E";
        CVV_I.value = "I";
        CVV_M.value = "M";
        CVV_N.value = "N";
        CVV_P.value = "P";
        CVV_S.value = "S";
        CVV_U.value = "U";
        CVV_X.value = "X";
        ENUM_ALL_OTHERS.value = "All others";
        CVV_0.value = "0";
        CVV_1.value = "1";
        CVV_2.value = "2";
        CVV_3.value = "3";
        CVV_4.value = "4";
        _UNKNOWN.value = null;

        valueMap.put("E", CVV_E);
        valueMap.put("I", CVV_I);
        valueMap.put("M", CVV_M);
        valueMap.put("N", CVV_N);
        valueMap.put("P", CVV_P);
        valueMap.put("S", CVV_S);
        valueMap.put("U", CVV_U);
        valueMap.put("X", CVV_X);
        valueMap.put("All others", ENUM_ALL_OTHERS);
        valueMap.put("0", CVV_0);
        valueMap.put("1", CVV_1);
        valueMap.put("2", CVV_2);
        valueMap.put("3", CVV_3);
        valueMap.put("4", CVV_4);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static CvvCode constructFromString(String toConvert) throws IOException {
        CvvCode enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static CvvCode fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of CvvCode values to list of string values.
     * @param toConvert The list of CvvCode values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<CvvCode> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (CvvCode enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 