/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for ExchangeRate type.
 */
public class ExchangeRate {
    private String sourceCurrency;
    private String targetCurrency;
    private String value;

    /**
     * Default constructor.
     */
    public ExchangeRate() {
    }

    /**
     * Initialization constructor.
     * @param  sourceCurrency  String value for sourceCurrency.
     * @param  targetCurrency  String value for targetCurrency.
     * @param  value  String value for value.
     */
    public ExchangeRate(
            String sourceCurrency,
            String targetCurrency,
            String value) {
        this.sourceCurrency = sourceCurrency;
        this.targetCurrency = targetCurrency;
        this.value = value;
    }

    /**
     * Getter for SourceCurrency.
     * The [three-character ISO-4217 currency code](/api/rest/reference/currency-codes/) that
     * identifies the currency.
     * @return Returns the String
     */
    @JsonGetter("source_currency")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getSourceCurrency() {
        return sourceCurrency;
    }

    /**
     * Setter for SourceCurrency.
     * The [three-character ISO-4217 currency code](/api/rest/reference/currency-codes/) that
     * identifies the currency.
     * @param sourceCurrency Value for String
     */
    @JsonSetter("source_currency")
    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    /**
     * Getter for TargetCurrency.
     * The [three-character ISO-4217 currency code](/api/rest/reference/currency-codes/) that
     * identifies the currency.
     * @return Returns the String
     */
    @JsonGetter("target_currency")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getTargetCurrency() {
        return targetCurrency;
    }

    /**
     * Setter for TargetCurrency.
     * The [three-character ISO-4217 currency code](/api/rest/reference/currency-codes/) that
     * identifies the currency.
     * @param targetCurrency Value for String
     */
    @JsonSetter("target_currency")
    public void setTargetCurrency(String targetCurrency) {
        this.targetCurrency = targetCurrency;
    }

    /**
     * Getter for Value.
     * The target currency amount. Equivalent to one unit of the source currency. Formatted as
     * integer or decimal value with one to 15 digits to the right of the decimal point.
     * @return Returns the String
     */
    @JsonGetter("value")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getValue() {
        return value;
    }

    /**
     * Setter for Value.
     * The target currency amount. Equivalent to one unit of the source currency. Formatted as
     * integer or decimal value with one to 15 digits to the right of the decimal point.
     * @param value Value for String
     */
    @JsonSetter("value")
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Converts this ExchangeRate into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "ExchangeRate [" + "sourceCurrency=" + sourceCurrency + ", targetCurrency="
                + targetCurrency + ", value=" + value + "]";
    }

    /**
     * Builds a new {@link ExchangeRate.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link ExchangeRate.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .sourceCurrency(getSourceCurrency())
                .targetCurrency(getTargetCurrency())
                .value(getValue());
        return builder;
    }

    /**
     * Class to build instances of {@link ExchangeRate}.
     */
    public static class Builder {
        private String sourceCurrency;
        private String targetCurrency;
        private String value;



        /**
         * Setter for sourceCurrency.
         * @param  sourceCurrency  String value for sourceCurrency.
         * @return Builder
         */
        public Builder sourceCurrency(String sourceCurrency) {
            this.sourceCurrency = sourceCurrency;
            return this;
        }

        /**
         * Setter for targetCurrency.
         * @param  targetCurrency  String value for targetCurrency.
         * @return Builder
         */
        public Builder targetCurrency(String targetCurrency) {
            this.targetCurrency = targetCurrency;
            return this;
        }

        /**
         * Setter for value.
         * @param  value  String value for value.
         * @return Builder
         */
        public Builder value(String value) {
            this.value = value;
            return this;
        }

        /**
         * Builds a new {@link ExchangeRate} object using the set fields.
         * @return {@link ExchangeRate}
         */
        public ExchangeRate build() {
            return new ExchangeRate(sourceCurrency, targetCurrency, value);
        }
    }
}
