/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for GetAuthorizedPaymentInput type.
 */
public class GetAuthorizedPaymentInput {
    private String authorizationId;
    private String paypalMockResponse;
    private String paypalAuthAssertion;

    /**
     * Default constructor.
     */
    public GetAuthorizedPaymentInput() {
    }

    /**
     * Initialization constructor.
     * @param  authorizationId  String value for authorizationId.
     * @param  paypalMockResponse  String value for paypalMockResponse.
     * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
     */
    public GetAuthorizedPaymentInput(
            String authorizationId,
            String paypalMockResponse,
            String paypalAuthAssertion) {
        this.authorizationId = authorizationId;
        this.paypalMockResponse = paypalMockResponse;
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    /**
     * Getter for AuthorizationId.
     * The ID of the authorized payment for which to show details.
     * @return Returns the String
     */
    @JsonGetter("authorization_id")
    public String getAuthorizationId() {
        return authorizationId;
    }

    /**
     * Setter for AuthorizationId.
     * The ID of the authorized payment for which to show details.
     * @param authorizationId Value for String
     */
    @JsonSetter("authorization_id")
    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    /**
     * Getter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Mock-Response")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalMockResponse() {
        return paypalMockResponse;
    }

    /**
     * Setter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @param paypalMockResponse Value for String
     */
    @JsonSetter("PayPal-Mock-Response")
    public void setPaypalMockResponse(String paypalMockResponse) {
        this.paypalMockResponse = paypalMockResponse;
    }

    /**
     * Getter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see
     * [PayPal-Auth-Assertion](/docs/api/reference/api-requests/#paypal-auth-assertion). Note:For
     * three party transactions in which a partner is managing the API calls on behalf of a
     * merchant, the partner must identify the merchant using either a PayPal-Auth-Assertion header
     * or an access token with target_subject.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Auth-Assertion")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return paypalAuthAssertion;
    }

    /**
     * Setter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see
     * [PayPal-Auth-Assertion](/docs/api/reference/api-requests/#paypal-auth-assertion). Note:For
     * three party transactions in which a partner is managing the API calls on behalf of a
     * merchant, the partner must identify the merchant using either a PayPal-Auth-Assertion header
     * or an access token with target_subject.
     * @param paypalAuthAssertion Value for String
     */
    @JsonSetter("PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    /**
     * Converts this GetAuthorizedPaymentInput into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "GetAuthorizedPaymentInput [" + "authorizationId=" + authorizationId
                + ", paypalMockResponse=" + paypalMockResponse + ", paypalAuthAssertion="
                + paypalAuthAssertion + "]";
    }

    /**
     * Builds a new {@link GetAuthorizedPaymentInput.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link GetAuthorizedPaymentInput.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(authorizationId)
                .paypalMockResponse(getPaypalMockResponse())
                .paypalAuthAssertion(getPaypalAuthAssertion());
        return builder;
    }

    /**
     * Class to build instances of {@link GetAuthorizedPaymentInput}.
     */
    public static class Builder {
        private String authorizationId;
        private String paypalMockResponse;
        private String paypalAuthAssertion;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  authorizationId  String value for authorizationId.
         */
        public Builder(String authorizationId) {
            this.authorizationId = authorizationId;
        }

        /**
         * Setter for authorizationId.
         * @param  authorizationId  String value for authorizationId.
         * @return Builder
         */
        public Builder authorizationId(String authorizationId) {
            this.authorizationId = authorizationId;
            return this;
        }

        /**
         * Setter for paypalMockResponse.
         * @param  paypalMockResponse  String value for paypalMockResponse.
         * @return Builder
         */
        public Builder paypalMockResponse(String paypalMockResponse) {
            this.paypalMockResponse = paypalMockResponse;
            return this;
        }

        /**
         * Setter for paypalAuthAssertion.
         * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
         * @return Builder
         */
        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        /**
         * Builds a new {@link GetAuthorizedPaymentInput} object using the set fields.
         * @return {@link GetAuthorizedPaymentInput}
         */
        public GetAuthorizedPaymentInput build() {
            return new GetAuthorizedPaymentInput(authorizationId, paypalMockResponse,
                    paypalAuthAssertion);
        }
    }
}
