/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for GetCapturedPaymentInput type.
 */
public class GetCapturedPaymentInput {
    private String captureId;
    private String paypalMockResponse;

    /**
     * Default constructor.
     */
    public GetCapturedPaymentInput() {
    }

    /**
     * Initialization constructor.
     * @param  captureId  String value for captureId.
     * @param  paypalMockResponse  String value for paypalMockResponse.
     */
    public GetCapturedPaymentInput(
            String captureId,
            String paypalMockResponse) {
        this.captureId = captureId;
        this.paypalMockResponse = paypalMockResponse;
    }

    /**
     * Getter for CaptureId.
     * The PayPal-generated ID for the captured payment for which to show details.
     * @return Returns the String
     */
    @JsonGetter("capture_id")
    public String getCaptureId() {
        return captureId;
    }

    /**
     * Setter for CaptureId.
     * The PayPal-generated ID for the captured payment for which to show details.
     * @param captureId Value for String
     */
    @JsonSetter("capture_id")
    public void setCaptureId(String captureId) {
        this.captureId = captureId;
    }

    /**
     * Getter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Mock-Response")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalMockResponse() {
        return paypalMockResponse;
    }

    /**
     * Setter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @param paypalMockResponse Value for String
     */
    @JsonSetter("PayPal-Mock-Response")
    public void setPaypalMockResponse(String paypalMockResponse) {
        this.paypalMockResponse = paypalMockResponse;
    }

    /**
     * Converts this GetCapturedPaymentInput into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "GetCapturedPaymentInput [" + "captureId=" + captureId + ", paypalMockResponse="
                + paypalMockResponse + "]";
    }

    /**
     * Builds a new {@link GetCapturedPaymentInput.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link GetCapturedPaymentInput.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(captureId)
                .paypalMockResponse(getPaypalMockResponse());
        return builder;
    }

    /**
     * Class to build instances of {@link GetCapturedPaymentInput}.
     */
    public static class Builder {
        private String captureId;
        private String paypalMockResponse;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  captureId  String value for captureId.
         */
        public Builder(String captureId) {
            this.captureId = captureId;
        }

        /**
         * Setter for captureId.
         * @param  captureId  String value for captureId.
         * @return Builder
         */
        public Builder captureId(String captureId) {
            this.captureId = captureId;
            return this;
        }

        /**
         * Setter for paypalMockResponse.
         * @param  paypalMockResponse  String value for paypalMockResponse.
         * @return Builder
         */
        public Builder paypalMockResponse(String paypalMockResponse) {
            this.paypalMockResponse = paypalMockResponse;
            return this;
        }

        /**
         * Builds a new {@link GetCapturedPaymentInput} object using the set fields.
         * @return {@link GetCapturedPaymentInput}
         */
        public GetCapturedPaymentInput build() {
            return new GetCapturedPaymentInput(captureId, paypalMockResponse);
        }
    }
}
