/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for GetOrderInput type.
 */
public class GetOrderInput {
    private String id;
    private String paypalMockResponse;
    private String paypalAuthAssertion;
    private String fields;

    /**
     * Default constructor.
     */
    public GetOrderInput() {
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  paypalMockResponse  String value for paypalMockResponse.
     * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
     * @param  fields  String value for fields.
     */
    public GetOrderInput(
            String id,
            String paypalMockResponse,
            String paypalAuthAssertion,
            String fields) {
        this.id = id;
        this.paypalMockResponse = paypalMockResponse;
        this.paypalAuthAssertion = paypalAuthAssertion;
        this.fields = fields;
    }

    /**
     * Getter for Id.
     * The ID of the order for which to show details.
     * @return Returns the String
     */
    @JsonGetter("id")
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * The ID of the order for which to show details.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Mock-Response")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalMockResponse() {
        return paypalMockResponse;
    }

    /**
     * Setter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @param paypalMockResponse Value for String
     */
    @JsonSetter("PayPal-Mock-Response")
    public void setPaypalMockResponse(String paypalMockResponse) {
        this.paypalMockResponse = paypalMockResponse;
    }

    /**
     * Getter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see PayPal-Auth-Assertion.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Auth-Assertion")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return paypalAuthAssertion;
    }

    /**
     * Setter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see PayPal-Auth-Assertion.
     * @param paypalAuthAssertion Value for String
     */
    @JsonSetter("PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    /**
     * Getter for Fields.
     * A comma-separated list of fields that should be returned for the order. Valid filter field is
     * `payment_source`.
     * @return Returns the String
     */
    @JsonGetter("fields")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getFields() {
        return fields;
    }

    /**
     * Setter for Fields.
     * A comma-separated list of fields that should be returned for the order. Valid filter field is
     * `payment_source`.
     * @param fields Value for String
     */
    @JsonSetter("fields")
    public void setFields(String fields) {
        this.fields = fields;
    }

    /**
     * Converts this GetOrderInput into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "GetOrderInput [" + "id=" + id + ", paypalMockResponse=" + paypalMockResponse
                + ", paypalAuthAssertion=" + paypalAuthAssertion + ", fields=" + fields + "]";
    }

    /**
     * Builds a new {@link GetOrderInput.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link GetOrderInput.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(id)
                .paypalMockResponse(getPaypalMockResponse())
                .paypalAuthAssertion(getPaypalAuthAssertion())
                .fields(getFields());
        return builder;
    }

    /**
     * Class to build instances of {@link GetOrderInput}.
     */
    public static class Builder {
        private String id;
        private String paypalMockResponse;
        private String paypalAuthAssertion;
        private String fields;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  id  String value for id.
         */
        public Builder(String id) {
            this.id = id;
        }

        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for paypalMockResponse.
         * @param  paypalMockResponse  String value for paypalMockResponse.
         * @return Builder
         */
        public Builder paypalMockResponse(String paypalMockResponse) {
            this.paypalMockResponse = paypalMockResponse;
            return this;
        }

        /**
         * Setter for paypalAuthAssertion.
         * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
         * @return Builder
         */
        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        /**
         * Setter for fields.
         * @param  fields  String value for fields.
         * @return Builder
         */
        public Builder fields(String fields) {
            this.fields = fields;
            return this;
        }

        /**
         * Builds a new {@link GetOrderInput} object using the set fields.
         * @return {@link GetOrderInput}
         */
        public GetOrderInput build() {
            return new GetOrderInput(id, paypalMockResponse, paypalAuthAssertion, fields);
        }
    }
}
