/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for LinkDescription type.
 */
public class LinkDescription {
    private String href;
    private String rel;
    private LinkHttpMethod method;

    /**
     * Default constructor.
     */
    public LinkDescription() {
    }

    /**
     * Initialization constructor.
     * @param  href  String value for href.
     * @param  rel  String value for rel.
     * @param  method  LinkHttpMethod value for method.
     */
    public LinkDescription(
            String href,
            String rel,
            LinkHttpMethod method) {
        this.href = href;
        this.rel = rel;
        this.method = method;
    }

    /**
     * Getter for Href.
     * The complete target URL. To make the related call, combine the method with this [URI
     * Template-formatted](https://tools.ietf.org/html/rfc6570) link. For pre-processing, include
     * the `$`, `(`, and `)` characters. The `href` is the key HATEOAS component that links a
     * completed call with a subsequent call.
     * @return Returns the String
     */
    @JsonGetter("href")
    public String getHref() {
        return href;
    }

    /**
     * Setter for Href.
     * The complete target URL. To make the related call, combine the method with this [URI
     * Template-formatted](https://tools.ietf.org/html/rfc6570) link. For pre-processing, include
     * the `$`, `(`, and `)` characters. The `href` is the key HATEOAS component that links a
     * completed call with a subsequent call.
     * @param href Value for String
     */
    @JsonSetter("href")
    public void setHref(String href) {
        this.href = href;
    }

    /**
     * Getter for Rel.
     * The [link relation type](https://tools.ietf.org/html/rfc5988#section-4), which serves as an
     * ID for a link that unambiguously describes the semantics of the link. See [Link
     * Relations](https://www.iana.org/assignments/link-relations/link-relations.xhtml).
     * @return Returns the String
     */
    @JsonGetter("rel")
    public String getRel() {
        return rel;
    }

    /**
     * Setter for Rel.
     * The [link relation type](https://tools.ietf.org/html/rfc5988#section-4), which serves as an
     * ID for a link that unambiguously describes the semantics of the link. See [Link
     * Relations](https://www.iana.org/assignments/link-relations/link-relations.xhtml).
     * @param rel Value for String
     */
    @JsonSetter("rel")
    public void setRel(String rel) {
        this.rel = rel;
    }

    /**
     * Getter for Method.
     * The HTTP method required to make the related call.
     * @return Returns the LinkHttpMethod
     */
    @JsonGetter("method")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public LinkHttpMethod getMethod() {
        return method;
    }

    /**
     * Setter for Method.
     * The HTTP method required to make the related call.
     * @param method Value for LinkHttpMethod
     */
    @JsonSetter("method")
    public void setMethod(LinkHttpMethod method) {
        this.method = method;
    }

    /**
     * Converts this LinkDescription into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "LinkDescription [" + "href=" + href + ", rel=" + rel + ", method=" + method + "]";
    }

    /**
     * Builds a new {@link LinkDescription.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link LinkDescription.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(href, rel)
                .method(getMethod());
        return builder;
    }

    /**
     * Class to build instances of {@link LinkDescription}.
     */
    public static class Builder {
        private String href;
        private String rel;
        private LinkHttpMethod method;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  href  String value for href.
         * @param  rel  String value for rel.
         */
        public Builder(String href, String rel) {
            this.href = href;
            this.rel = rel;
        }

        /**
         * Setter for href.
         * @param  href  String value for href.
         * @return Builder
         */
        public Builder href(String href) {
            this.href = href;
            return this;
        }

        /**
         * Setter for rel.
         * @param  rel  String value for rel.
         * @return Builder
         */
        public Builder rel(String rel) {
            this.rel = rel;
            return this;
        }

        /**
         * Setter for method.
         * @param  method  LinkHttpMethod value for method.
         * @return Builder
         */
        public Builder method(LinkHttpMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Builds a new {@link LinkDescription} object using the set fields.
         * @return {@link LinkDescription}
         */
        public LinkDescription build() {
            return new LinkDescription(href, rel, method);
        }
    }
}
