/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * OrderStatus to be used.
 */
public enum OrderStatus {
    /**
     * The order was created with the specified context.
     */
    CREATED,

    /**
     * The order was saved and persisted. The order status continues to be in progress until a capture is made with final_capture = true for all purchase units within the order.
     */
    SAVED,

    /**
     * The customer approved the payment through the PayPal wallet or another form of guest or unbranded payment. For example, a card, bank account, or so on.
     */
    APPROVED,

    /**
     * All purchase units in the order are voided.
     */
    VOIDED,

    /**
     * The intent of the Order was completed and a `payments` resource was created. A completed Order may have authorized a payment, captured an authorized payment, or in some cases, the payment may have been declined. Please verify the payment status under purchase_unitsArray.payments before proceeding with Order fulfillment.
     */
    COMPLETED,

    /**
     * The order requires an action from the payer (e.g. 3DS authentication). Redirect the payer to the "rel":"payer-action" HATEOAS link returned as part of the response prior to authorizing or capturing the order. Some payment sources may not return a payer-action HATEOAS link (eg. MB WAY). For these payment sources the payer-action is managed by the scheme itself (eg. through SMS, email, in-app notification, etc).
     */
    PAYER_ACTION_REQUIRED,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, OrderStatus> valueMap = new TreeMap<>();
    private String value;

    static {
        CREATED.value = "CREATED";
        SAVED.value = "SAVED";
        APPROVED.value = "APPROVED";
        VOIDED.value = "VOIDED";
        COMPLETED.value = "COMPLETED";
        PAYER_ACTION_REQUIRED.value = "PAYER_ACTION_REQUIRED";
        _UNKNOWN.value = null;

        valueMap.put("CREATED", CREATED);
        valueMap.put("SAVED", SAVED);
        valueMap.put("APPROVED", APPROVED);
        valueMap.put("VOIDED", VOIDED);
        valueMap.put("COMPLETED", COMPLETED);
        valueMap.put("PAYER_ACTION_REQUIRED", PAYER_ACTION_REQUIRED);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static OrderStatus constructFromString(String toConvert) throws IOException {
        OrderStatus enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static OrderStatus fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of OrderStatus values to list of string values.
     * @param toConvert The list of OrderStatus values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<OrderStatus> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (OrderStatus enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 