/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * OrdersCardVerificationMethod to be used.
 */
public enum OrdersCardVerificationMethod {
    /**
     * Selecting this option will attempt to force a strong customer authentication for the authorization/transaction. In countries where SCA has been defined and implemented it will result in a contingency and HATEOAS link being returned.  The API caller should redirect the payer to that link so that they can authenticate themselves against their issuing bank or other entity. As noted, the HATEOAS link is only available in all regions where strong authentication is supported, (e.g. in European countries where 3DS is live). Merchants can use this setting as an additional layer of security if they choose to. In all cases, when an authorization is requested the AVS/CVV results will be returned in the response.
     */
    SCA_ALWAYS,

    /**
     * This is the default. When an authorization or transaction is attempted this option will return a contingency and HATEOAS link only when local regulations require strong customer authentication, (e.g. 3DS in countries and use cases where it is mandated). The API caller should redirect the payer to the link so that they can authenticate themselves. In all cases, when an authorization is requested the AVS/CVV results will be returned in the response.
     */
    SCA_WHEN_REQUIRED,

    /**
     * The contingency surfaced as an additional security layer that helps prevent unauthorized card-not-present transactions and protects the merchant from exposure to fraud.
     */
    ENUM_3D_SECURE,

    /**
     * Places a temporary hold on the card to ensure its validity. This process protects the merchant from exposure to fraud. This verification method will confirm that the address information or CVV included matches what the issuing bank has on file for the associated card, ensuring that only authorized card users are able to make purchases from you.
     */
    AVS_CVV,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, OrdersCardVerificationMethod> valueMap = new TreeMap<>();
    private String value;

    static {
        SCA_ALWAYS.value = "SCA_ALWAYS";
        SCA_WHEN_REQUIRED.value = "SCA_WHEN_REQUIRED";
        ENUM_3D_SECURE.value = "3D_SECURE";
        AVS_CVV.value = "AVS_CVV";
        _UNKNOWN.value = null;

        valueMap.put("SCA_ALWAYS", SCA_ALWAYS);
        valueMap.put("SCA_WHEN_REQUIRED", SCA_WHEN_REQUIRED);
        valueMap.put("3D_SECURE", ENUM_3D_SECURE);
        valueMap.put("AVS_CVV", AVS_CVV);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static OrdersCardVerificationMethod constructFromString(String toConvert) throws IOException {
        OrdersCardVerificationMethod enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static OrdersCardVerificationMethod fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of OrdersCardVerificationMethod values to list of string values.
     * @param toConvert The list of OrdersCardVerificationMethod values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<OrdersCardVerificationMethod> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (OrdersCardVerificationMethod enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 