/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * PatchOp to be used.
 */
public enum PatchOp {
    /**
     * Depending on the target location reference, completes one of these functions: The target location is an array index. Inserts a new value into the array at the specified index. The target location is an object parameter that does not already exist. Adds a new parameter to the object. The target location is an object parameter that does exist. Replaces that parameter's value. The value parameter defines the value to add. For more information, see 4.1. add.
     */
    ADD,

    /**
     * Removes the value at the target location. For the operation to succeed, the target location must exist. For more information, see 4.2. remove.
     */
    REMOVE,

    /**
     * Replaces the value at the target location with a new value. The operation object must contain a value parameter that defines the replacement value. For the operation to succeed, the target location must exist. For more information, see 4.3. replace.
     */
    REPLACE,

    /**
     * Removes the value at a specified location and adds it to the target location. The operation object must contain a from parameter, which is a string that contains a JSON pointer value that references the location in the target document from which to move the value. For the operation to succeed, the from location must exist. For more information, see 4.4. move.
     */
    MOVE,

    /**
     * Copies the value at a specified location to the target location. The operation object must contain a from parameter, which is a string that contains a JSON pointer value that references the location in the target document from which to copy the value. For the operation to succeed, the from location must exist. For more information, see 4.5. copy.
     */
    COPY,

    /**
     * Tests that a value at the target location is equal to a specified value. The operation object must contain a value parameter that defines the value to compare to the target location's value. For the operation to succeed, the target location must be equal to the value value. For test, equal indicates that the value at the target location and the value that value defines are of the same JSON type. The data type of the value determines how equality is defined: Type Considered equal if both values strings Contain the same number of Unicode characters and their code points are byte-by-byte equal. numbers Are numerically equal. arrays Contain the same number of values, and each value is equal to the value at the corresponding position in the other array, by using these type-specific rules. objects Contain the same number of parameters, and each parameter is equal to a parameter in the other object, by comparing their keys (as strings) and their values (by using these type-specific rules). literals (false, true, and null) Are the same. The comparison is a logical comparison. For example, whitespace between the parameter values of an array is not significant. Also, ordering of the serialization of object parameters is not significant. For more information, see 4.6. test.
     */
    TEST,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, PatchOp> valueMap = new TreeMap<>();
    private String value;

    static {
        ADD.value = "add";
        REMOVE.value = "remove";
        REPLACE.value = "replace";
        MOVE.value = "move";
        COPY.value = "copy";
        TEST.value = "test";
        _UNKNOWN.value = null;

        valueMap.put("add", ADD);
        valueMap.put("remove", REMOVE);
        valueMap.put("replace", REPLACE);
        valueMap.put("move", MOVE);
        valueMap.put("copy", COPY);
        valueMap.put("test", TEST);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static PatchOp constructFromString(String toConvert) throws IOException {
        PatchOp enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static PatchOp fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of PatchOp values to list of string values.
     * @param toConvert The list of PatchOp values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<PatchOp> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (PatchOp enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 