/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for PaymentCollection type.
 */
public class PaymentCollection {
    private List<AuthorizationWithAdditionalData> authorizations;
    private List<OrdersCapture> captures;
    private List<Refund> refunds;

    /**
     * Default constructor.
     */
    public PaymentCollection() {
    }

    /**
     * Initialization constructor.
     * @param  authorizations  List of AuthorizationWithAdditionalData value for authorizations.
     * @param  captures  List of OrdersCapture value for captures.
     * @param  refunds  List of Refund value for refunds.
     */
    public PaymentCollection(
            List<AuthorizationWithAdditionalData> authorizations,
            List<OrdersCapture> captures,
            List<Refund> refunds) {
        this.authorizations = authorizations;
        this.captures = captures;
        this.refunds = refunds;
    }

    /**
     * Getter for Authorizations.
     * An array of authorized payments for a purchase unit. A purchase unit can have zero or more
     * authorized payments.
     * @return Returns the List of AuthorizationWithAdditionalData
     */
    @JsonGetter("authorizations")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<AuthorizationWithAdditionalData> getAuthorizations() {
        return authorizations;
    }

    /**
     * Setter for Authorizations.
     * An array of authorized payments for a purchase unit. A purchase unit can have zero or more
     * authorized payments.
     * @param authorizations Value for List of AuthorizationWithAdditionalData
     */
    @JsonSetter("authorizations")
    public void setAuthorizations(List<AuthorizationWithAdditionalData> authorizations) {
        this.authorizations = authorizations;
    }

    /**
     * Getter for Captures.
     * An array of captured payments for a purchase unit. A purchase unit can have zero or more
     * captured payments.
     * @return Returns the List of OrdersCapture
     */
    @JsonGetter("captures")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<OrdersCapture> getCaptures() {
        return captures;
    }

    /**
     * Setter for Captures.
     * An array of captured payments for a purchase unit. A purchase unit can have zero or more
     * captured payments.
     * @param captures Value for List of OrdersCapture
     */
    @JsonSetter("captures")
    public void setCaptures(List<OrdersCapture> captures) {
        this.captures = captures;
    }

    /**
     * Getter for Refunds.
     * An array of refunds for a purchase unit. A purchase unit can have zero or more refunds.
     * @return Returns the List of Refund
     */
    @JsonGetter("refunds")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<Refund> getRefunds() {
        return refunds;
    }

    /**
     * Setter for Refunds.
     * An array of refunds for a purchase unit. A purchase unit can have zero or more refunds.
     * @param refunds Value for List of Refund
     */
    @JsonSetter("refunds")
    public void setRefunds(List<Refund> refunds) {
        this.refunds = refunds;
    }

    /**
     * Converts this PaymentCollection into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "PaymentCollection [" + "authorizations=" + authorizations + ", captures=" + captures
                + ", refunds=" + refunds + "]";
    }

    /**
     * Builds a new {@link PaymentCollection.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link PaymentCollection.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .authorizations(getAuthorizations())
                .captures(getCaptures())
                .refunds(getRefunds());
        return builder;
    }

    /**
     * Class to build instances of {@link PaymentCollection}.
     */
    public static class Builder {
        private List<AuthorizationWithAdditionalData> authorizations;
        private List<OrdersCapture> captures;
        private List<Refund> refunds;



        /**
         * Setter for authorizations.
         * @param  authorizations  List of AuthorizationWithAdditionalData value for authorizations.
         * @return Builder
         */
        public Builder authorizations(List<AuthorizationWithAdditionalData> authorizations) {
            this.authorizations = authorizations;
            return this;
        }

        /**
         * Setter for captures.
         * @param  captures  List of OrdersCapture value for captures.
         * @return Builder
         */
        public Builder captures(List<OrdersCapture> captures) {
            this.captures = captures;
            return this;
        }

        /**
         * Setter for refunds.
         * @param  refunds  List of Refund value for refunds.
         * @return Builder
         */
        public Builder refunds(List<Refund> refunds) {
            this.refunds = refunds;
            return this;
        }

        /**
         * Builds a new {@link PaymentCollection} object using the set fields.
         * @return {@link PaymentCollection}
         */
        public PaymentCollection build() {
            return new PaymentCollection(authorizations, captures, refunds);
        }
    }
}
