/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * PaymentsPaymentAdviceCode to be used.
 */
public enum PaymentsPaymentAdviceCode {
    /**
     * For Mastercard, expired card account upgrade or portfolio sale conversion. Obtain new account information before next billing cycle.
     */
    PAYMENTADVICE_01,

    /**
     * For Mastercard, over credit limit or insufficient funds. Retry the transaction 72 hours later. For Visa, the card holder wants to stop only one specific payment in the recurring payment relationship. The merchant must NOT resubmit the same transaction. The merchant can continue the billing process in the subsequent billing period.
     */
    PAYMENTADVICE_02,

    /**
     * For Mastercard, account closed as fraudulent. Obtain another type of payment from customer due to account being closed or fraud. Possible reason: Account closed as fraudulent. For Visa, the card holder wants to stop all recurring payment transactions for a specific merchant. Stop recurring payment requests.
     */
    PAYMENTADVICE_03,

    /**
     * For Mastercard, the card holder has been unsuccessful at canceling recurring payment through merchant. Stop recurring payment requests. For Visa, all recurring payments were canceled for the card number requested. Stop recurring payment requests.
     */
    PAYMENTADVICE_21,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, PaymentsPaymentAdviceCode> valueMap = new TreeMap<>();
    private String value;

    static {
        PAYMENTADVICE_01.value = "01";
        PAYMENTADVICE_02.value = "02";
        PAYMENTADVICE_03.value = "03";
        PAYMENTADVICE_21.value = "21";
        _UNKNOWN.value = null;

        valueMap.put("01", PAYMENTADVICE_01);
        valueMap.put("02", PAYMENTADVICE_02);
        valueMap.put("03", PAYMENTADVICE_03);
        valueMap.put("21", PAYMENTADVICE_21);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static PaymentsPaymentAdviceCode constructFromString(String toConvert) throws IOException {
        PaymentsPaymentAdviceCode enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static PaymentsPaymentAdviceCode fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of PaymentsPaymentAdviceCode values to list of string values.
     * @param toConvert The list of PaymentsPaymentAdviceCode values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<PaymentsPaymentAdviceCode> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (PaymentsPaymentAdviceCode enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 