/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for PaymentsProcessorResponse type.
 */
public class PaymentsProcessorResponse {
    private AvsCode avsCode;
    private CvvCode cvvCode;
    private ProcessorResponseCode responseCode;
    private PaymentsPaymentAdviceCode paymentAdviceCode;

    /**
     * Default constructor.
     */
    public PaymentsProcessorResponse() {
    }

    /**
     * Initialization constructor.
     * @param  avsCode  AvsCode value for avsCode.
     * @param  cvvCode  CvvCode value for cvvCode.
     * @param  responseCode  ProcessorResponseCode value for responseCode.
     * @param  paymentAdviceCode  PaymentsPaymentAdviceCode value for paymentAdviceCode.
     */
    public PaymentsProcessorResponse(
            AvsCode avsCode,
            CvvCode cvvCode,
            ProcessorResponseCode responseCode,
            PaymentsPaymentAdviceCode paymentAdviceCode) {
        this.avsCode = avsCode;
        this.cvvCode = cvvCode;
        this.responseCode = responseCode;
        this.paymentAdviceCode = paymentAdviceCode;
    }

    /**
     * Getter for AvsCode.
     * The address verification code for Visa, Discover, Mastercard, or American Express
     * transactions.
     * @return Returns the AvsCode
     */
    @JsonGetter("avs_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public AvsCode getAvsCode() {
        return avsCode;
    }

    /**
     * Setter for AvsCode.
     * The address verification code for Visa, Discover, Mastercard, or American Express
     * transactions.
     * @param avsCode Value for AvsCode
     */
    @JsonSetter("avs_code")
    public void setAvsCode(AvsCode avsCode) {
        this.avsCode = avsCode;
    }

    /**
     * Getter for CvvCode.
     * The card verification value code for for Visa, Discover, Mastercard, or American Express.
     * @return Returns the CvvCode
     */
    @JsonGetter("cvv_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CvvCode getCvvCode() {
        return cvvCode;
    }

    /**
     * Setter for CvvCode.
     * The card verification value code for for Visa, Discover, Mastercard, or American Express.
     * @param cvvCode Value for CvvCode
     */
    @JsonSetter("cvv_code")
    public void setCvvCode(CvvCode cvvCode) {
        this.cvvCode = cvvCode;
    }

    /**
     * Getter for ResponseCode.
     * Processor response code for the non-PayPal payment processor errors.
     * @return Returns the ProcessorResponseCode
     */
    @JsonGetter("response_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ProcessorResponseCode getResponseCode() {
        return responseCode;
    }

    /**
     * Setter for ResponseCode.
     * Processor response code for the non-PayPal payment processor errors.
     * @param responseCode Value for ProcessorResponseCode
     */
    @JsonSetter("response_code")
    public void setResponseCode(ProcessorResponseCode responseCode) {
        this.responseCode = responseCode;
    }

    /**
     * Getter for PaymentAdviceCode.
     * The declined payment transactions might have payment advice codes. The card networks, like
     * Visa and Mastercard, return payment advice codes.
     * @return Returns the PaymentsPaymentAdviceCode
     */
    @JsonGetter("payment_advice_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaymentsPaymentAdviceCode getPaymentAdviceCode() {
        return paymentAdviceCode;
    }

    /**
     * Setter for PaymentAdviceCode.
     * The declined payment transactions might have payment advice codes. The card networks, like
     * Visa and Mastercard, return payment advice codes.
     * @param paymentAdviceCode Value for PaymentsPaymentAdviceCode
     */
    @JsonSetter("payment_advice_code")
    public void setPaymentAdviceCode(PaymentsPaymentAdviceCode paymentAdviceCode) {
        this.paymentAdviceCode = paymentAdviceCode;
    }

    /**
     * Converts this PaymentsProcessorResponse into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "PaymentsProcessorResponse [" + "avsCode=" + avsCode + ", cvvCode=" + cvvCode
                + ", responseCode=" + responseCode + ", paymentAdviceCode=" + paymentAdviceCode
                + "]";
    }

    /**
     * Builds a new {@link PaymentsProcessorResponse.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link PaymentsProcessorResponse.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .avsCode(getAvsCode())
                .cvvCode(getCvvCode())
                .responseCode(getResponseCode())
                .paymentAdviceCode(getPaymentAdviceCode());
        return builder;
    }

    /**
     * Class to build instances of {@link PaymentsProcessorResponse}.
     */
    public static class Builder {
        private AvsCode avsCode;
        private CvvCode cvvCode;
        private ProcessorResponseCode responseCode;
        private PaymentsPaymentAdviceCode paymentAdviceCode;



        /**
         * Setter for avsCode.
         * @param  avsCode  AvsCode value for avsCode.
         * @return Builder
         */
        public Builder avsCode(AvsCode avsCode) {
            this.avsCode = avsCode;
            return this;
        }

        /**
         * Setter for cvvCode.
         * @param  cvvCode  CvvCode value for cvvCode.
         * @return Builder
         */
        public Builder cvvCode(CvvCode cvvCode) {
            this.cvvCode = cvvCode;
            return this;
        }

        /**
         * Setter for responseCode.
         * @param  responseCode  ProcessorResponseCode value for responseCode.
         * @return Builder
         */
        public Builder responseCode(ProcessorResponseCode responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        /**
         * Setter for paymentAdviceCode.
         * @param  paymentAdviceCode  PaymentsPaymentAdviceCode value for paymentAdviceCode.
         * @return Builder
         */
        public Builder paymentAdviceCode(PaymentsPaymentAdviceCode paymentAdviceCode) {
            this.paymentAdviceCode = paymentAdviceCode;
            return this;
        }

        /**
         * Builds a new {@link PaymentsProcessorResponse} object using the set fields.
         * @return {@link PaymentsProcessorResponse}
         */
        public PaymentsProcessorResponse build() {
            return new PaymentsProcessorResponse(avsCode, cvvCode, responseCode, paymentAdviceCode);
        }
    }
}
