/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for PaypalWalletResponse type.
 */
public class PaypalWalletResponse {
    private String emailAddress;
    private String accountId;
    private PaypalWalletAccountVerificationStatus accountStatus;
    private Name name;
    private PhoneType phoneType;
    private PhoneNumber phoneNumber;
    private String birthDate;
    private String businessName;
    private TaxInfo taxInfo;
    private Address address;
    private PaypalWalletAttributesResponse attributes;
    private PaypalWalletStoredCredential storedCredential;

    /**
     * Default constructor.
     */
    public PaypalWalletResponse() {
    }

    /**
     * Initialization constructor.
     * @param  emailAddress  String value for emailAddress.
     * @param  accountId  String value for accountId.
     * @param  accountStatus  PaypalWalletAccountVerificationStatus value for accountStatus.
     * @param  name  Name value for name.
     * @param  phoneType  PhoneType value for phoneType.
     * @param  phoneNumber  PhoneNumber value for phoneNumber.
     * @param  birthDate  String value for birthDate.
     * @param  businessName  String value for businessName.
     * @param  taxInfo  TaxInfo value for taxInfo.
     * @param  address  Address value for address.
     * @param  attributes  PaypalWalletAttributesResponse value for attributes.
     * @param  storedCredential  PaypalWalletStoredCredential value for storedCredential.
     */
    public PaypalWalletResponse(
            String emailAddress,
            String accountId,
            PaypalWalletAccountVerificationStatus accountStatus,
            Name name,
            PhoneType phoneType,
            PhoneNumber phoneNumber,
            String birthDate,
            String businessName,
            TaxInfo taxInfo,
            Address address,
            PaypalWalletAttributesResponse attributes,
            PaypalWalletStoredCredential storedCredential) {
        this.emailAddress = emailAddress;
        this.accountId = accountId;
        this.accountStatus = accountStatus;
        this.name = name;
        this.phoneType = phoneType;
        this.phoneNumber = phoneNumber;
        this.birthDate = birthDate;
        this.businessName = businessName;
        this.taxInfo = taxInfo;
        this.address = address;
        this.attributes = attributes;
        this.storedCredential = storedCredential;
    }

    /**
     * Getter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @return Returns the String
     */
    @JsonGetter("email_address")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return emailAddress;
    }

    /**
     * Setter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @param emailAddress Value for String
     */
    @JsonSetter("email_address")
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /**
     * Getter for AccountId.
     * The PayPal payer ID, which is a masked version of the PayPal account number intended for use
     * with third parties. The account number is reversibly encrypted and a proprietary variant of
     * Base32 is used to encode the result.
     * @return Returns the String
     */
    @JsonGetter("account_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getAccountId() {
        return accountId;
    }

    /**
     * Setter for AccountId.
     * The PayPal payer ID, which is a masked version of the PayPal account number intended for use
     * with third parties. The account number is reversibly encrypted and a proprietary variant of
     * Base32 is used to encode the result.
     * @param accountId Value for String
     */
    @JsonSetter("account_id")
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    /**
     * Getter for AccountStatus.
     * The account status indicates whether the buyer has verified the financial details associated
     * with their PayPal account.
     * @return Returns the PaypalWalletAccountVerificationStatus
     */
    @JsonGetter("account_status")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaypalWalletAccountVerificationStatus getAccountStatus() {
        return accountStatus;
    }

    /**
     * Setter for AccountStatus.
     * The account status indicates whether the buyer has verified the financial details associated
     * with their PayPal account.
     * @param accountStatus Value for PaypalWalletAccountVerificationStatus
     */
    @JsonSetter("account_status")
    public void setAccountStatus(PaypalWalletAccountVerificationStatus accountStatus) {
        this.accountStatus = accountStatus;
    }

    /**
     * Getter for Name.
     * The name of the party.
     * @return Returns the Name
     */
    @JsonGetter("name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Name getName() {
        return name;
    }

    /**
     * Setter for Name.
     * The name of the party.
     * @param name Value for Name
     */
    @JsonSetter("name")
    public void setName(Name name) {
        this.name = name;
    }

    /**
     * Getter for PhoneType.
     * The phone type.
     * @return Returns the PhoneType
     */
    @JsonGetter("phone_type")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PhoneType getPhoneType() {
        return phoneType;
    }

    /**
     * Setter for PhoneType.
     * The phone type.
     * @param phoneType Value for PhoneType
     */
    @JsonSetter("phone_type")
    public void setPhoneType(PhoneType phoneType) {
        this.phoneType = phoneType;
    }

    /**
     * Getter for PhoneNumber.
     * The phone number in its canonical international [E.164 numbering plan
     * format](https://www.itu.int/rec/T-REC-E.164/en).
     * @return Returns the PhoneNumber
     */
    @JsonGetter("phone_number")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PhoneNumber getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * Setter for PhoneNumber.
     * The phone number in its canonical international [E.164 numbering plan
     * format](https://www.itu.int/rec/T-REC-E.164/en).
     * @param phoneNumber Value for PhoneNumber
     */
    @JsonSetter("phone_number")
    public void setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /**
     * Getter for BirthDate.
     * The stand-alone date, in [Internet date and time
     * format](https://tools.ietf.org/html/rfc3339#section-5.6). To represent special legal values,
     * such as a date of birth, you should use dates with no associated time or time-zone data.
     * Whenever possible, use the standard `date_time` type. This regular expression does not
     * validate all dates. For example, February 31 is valid and nothing is known about leap years.
     * @return Returns the String
     */
    @JsonGetter("birth_date")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getBirthDate() {
        return birthDate;
    }

    /**
     * Setter for BirthDate.
     * The stand-alone date, in [Internet date and time
     * format](https://tools.ietf.org/html/rfc3339#section-5.6). To represent special legal values,
     * such as a date of birth, you should use dates with no associated time or time-zone data.
     * Whenever possible, use the standard `date_time` type. This regular expression does not
     * validate all dates. For example, February 31 is valid and nothing is known about leap years.
     * @param birthDate Value for String
     */
    @JsonSetter("birth_date")
    public void setBirthDate(String birthDate) {
        this.birthDate = birthDate;
    }

    /**
     * Getter for BusinessName.
     * The business name of the PayPal account holder (populated for business accounts only)
     * @return Returns the String
     */
    @JsonGetter("business_name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getBusinessName() {
        return businessName;
    }

    /**
     * Setter for BusinessName.
     * The business name of the PayPal account holder (populated for business accounts only)
     * @param businessName Value for String
     */
    @JsonSetter("business_name")
    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    /**
     * Getter for TaxInfo.
     * The tax ID of the customer. The customer is also known as the payer. Both `tax_id` and
     * `tax_id_type` are required.
     * @return Returns the TaxInfo
     */
    @JsonGetter("tax_info")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public TaxInfo getTaxInfo() {
        return taxInfo;
    }

    /**
     * Setter for TaxInfo.
     * The tax ID of the customer. The customer is also known as the payer. Both `tax_id` and
     * `tax_id_type` are required.
     * @param taxInfo Value for TaxInfo
     */
    @JsonSetter("tax_info")
    public void setTaxInfo(TaxInfo taxInfo) {
        this.taxInfo = taxInfo;
    }

    /**
     * Getter for Address.
     * The portable international postal address. Maps to
     * [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata)
     * and HTML 5.1 [Autofilling form controls: the autocomplete
     * attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute).
     * @return Returns the Address
     */
    @JsonGetter("address")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Address getAddress() {
        return address;
    }

    /**
     * Setter for Address.
     * The portable international postal address. Maps to
     * [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata)
     * and HTML 5.1 [Autofilling form controls: the autocomplete
     * attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute).
     * @param address Value for Address
     */
    @JsonSetter("address")
    public void setAddress(Address address) {
        this.address = address;
    }

    /**
     * Getter for Attributes.
     * Additional attributes associated with the use of a PayPal Wallet.
     * @return Returns the PaypalWalletAttributesResponse
     */
    @JsonGetter("attributes")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaypalWalletAttributesResponse getAttributes() {
        return attributes;
    }

    /**
     * Setter for Attributes.
     * Additional attributes associated with the use of a PayPal Wallet.
     * @param attributes Value for PaypalWalletAttributesResponse
     */
    @JsonSetter("attributes")
    public void setAttributes(PaypalWalletAttributesResponse attributes) {
        this.attributes = attributes;
    }

    /**
     * Getter for StoredCredential.
     * Provides additional details to process a payment using the PayPal wallet billing agreement or
     * a vaulted payment method that has been stored or is intended to be stored.
     * @return Returns the PaypalWalletStoredCredential
     */
    @JsonGetter("stored_credential")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaypalWalletStoredCredential getStoredCredential() {
        return storedCredential;
    }

    /**
     * Setter for StoredCredential.
     * Provides additional details to process a payment using the PayPal wallet billing agreement or
     * a vaulted payment method that has been stored or is intended to be stored.
     * @param storedCredential Value for PaypalWalletStoredCredential
     */
    @JsonSetter("stored_credential")
    public void setStoredCredential(PaypalWalletStoredCredential storedCredential) {
        this.storedCredential = storedCredential;
    }

    /**
     * Converts this PaypalWalletResponse into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "PaypalWalletResponse [" + "emailAddress=" + emailAddress + ", accountId="
                + accountId + ", accountStatus=" + accountStatus + ", name=" + name + ", phoneType="
                + phoneType + ", phoneNumber=" + phoneNumber + ", birthDate=" + birthDate
                + ", businessName=" + businessName + ", taxInfo=" + taxInfo + ", address=" + address
                + ", attributes=" + attributes + ", storedCredential=" + storedCredential + "]";
    }

    /**
     * Builds a new {@link PaypalWalletResponse.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link PaypalWalletResponse.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .emailAddress(getEmailAddress())
                .accountId(getAccountId())
                .accountStatus(getAccountStatus())
                .name(getName())
                .phoneType(getPhoneType())
                .phoneNumber(getPhoneNumber())
                .birthDate(getBirthDate())
                .businessName(getBusinessName())
                .taxInfo(getTaxInfo())
                .address(getAddress())
                .attributes(getAttributes())
                .storedCredential(getStoredCredential());
        return builder;
    }

    /**
     * Class to build instances of {@link PaypalWalletResponse}.
     */
    public static class Builder {
        private String emailAddress;
        private String accountId;
        private PaypalWalletAccountVerificationStatus accountStatus;
        private Name name;
        private PhoneType phoneType;
        private PhoneNumber phoneNumber;
        private String birthDate;
        private String businessName;
        private TaxInfo taxInfo;
        private Address address;
        private PaypalWalletAttributesResponse attributes;
        private PaypalWalletStoredCredential storedCredential;



        /**
         * Setter for emailAddress.
         * @param  emailAddress  String value for emailAddress.
         * @return Builder
         */
        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        /**
         * Setter for accountId.
         * @param  accountId  String value for accountId.
         * @return Builder
         */
        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        /**
         * Setter for accountStatus.
         * @param  accountStatus  PaypalWalletAccountVerificationStatus value for accountStatus.
         * @return Builder
         */
        public Builder accountStatus(PaypalWalletAccountVerificationStatus accountStatus) {
            this.accountStatus = accountStatus;
            return this;
        }

        /**
         * Setter for name.
         * @param  name  Name value for name.
         * @return Builder
         */
        public Builder name(Name name) {
            this.name = name;
            return this;
        }

        /**
         * Setter for phoneType.
         * @param  phoneType  PhoneType value for phoneType.
         * @return Builder
         */
        public Builder phoneType(PhoneType phoneType) {
            this.phoneType = phoneType;
            return this;
        }

        /**
         * Setter for phoneNumber.
         * @param  phoneNumber  PhoneNumber value for phoneNumber.
         * @return Builder
         */
        public Builder phoneNumber(PhoneNumber phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        /**
         * Setter for birthDate.
         * @param  birthDate  String value for birthDate.
         * @return Builder
         */
        public Builder birthDate(String birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        /**
         * Setter for businessName.
         * @param  businessName  String value for businessName.
         * @return Builder
         */
        public Builder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        /**
         * Setter for taxInfo.
         * @param  taxInfo  TaxInfo value for taxInfo.
         * @return Builder
         */
        public Builder taxInfo(TaxInfo taxInfo) {
            this.taxInfo = taxInfo;
            return this;
        }

        /**
         * Setter for address.
         * @param  address  Address value for address.
         * @return Builder
         */
        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        /**
         * Setter for attributes.
         * @param  attributes  PaypalWalletAttributesResponse value for attributes.
         * @return Builder
         */
        public Builder attributes(PaypalWalletAttributesResponse attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Setter for storedCredential.
         * @param  storedCredential  PaypalWalletStoredCredential value for storedCredential.
         * @return Builder
         */
        public Builder storedCredential(PaypalWalletStoredCredential storedCredential) {
            this.storedCredential = storedCredential;
            return this;
        }

        /**
         * Builds a new {@link PaypalWalletResponse} object using the set fields.
         * @return {@link PaypalWalletResponse}
         */
        public PaypalWalletResponse build() {
            return new PaypalWalletResponse(emailAddress, accountId, accountStatus, name, phoneType,
                    phoneNumber, birthDate, businessName, taxInfo, address, attributes,
                    storedCredential);
        }
    }
}
