/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for RefundCapturedPaymentInput type.
 */
public class RefundCapturedPaymentInput {
    private String captureId;
    private String contentType;
    private String paypalMockResponse;
    private String paypalRequestId;
    private String prefer;
    private String paypalAuthAssertion;
    private RefundRequest body;

    /**
     * Default constructor.
     */
    public RefundCapturedPaymentInput() {
        contentType = "application/json";
        prefer = "return=minimal";
    }

    /**
     * Initialization constructor.
     * @param  captureId  String value for captureId.
     * @param  contentType  String value for contentType.
     * @param  paypalMockResponse  String value for paypalMockResponse.
     * @param  paypalRequestId  String value for paypalRequestId.
     * @param  prefer  String value for prefer.
     * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
     * @param  body  RefundRequest value for body.
     */
    public RefundCapturedPaymentInput(
            String captureId,
            String contentType,
            String paypalMockResponse,
            String paypalRequestId,
            String prefer,
            String paypalAuthAssertion,
            RefundRequest body) {
        this.captureId = captureId;
        this.contentType = contentType;
        this.paypalMockResponse = paypalMockResponse;
        this.paypalRequestId = paypalRequestId;
        this.prefer = prefer;
        this.paypalAuthAssertion = paypalAuthAssertion;
        this.body = body;
    }

    /**
     * Getter for CaptureId.
     * The PayPal-generated ID for the captured payment to refund.
     * @return Returns the String
     */
    @JsonGetter("capture_id")
    public String getCaptureId() {
        return captureId;
    }

    /**
     * Setter for CaptureId.
     * The PayPal-generated ID for the captured payment to refund.
     * @param captureId Value for String
     */
    @JsonSetter("capture_id")
    public void setCaptureId(String captureId) {
        this.captureId = captureId;
    }

    /**
     * Getter for ContentType.
     * @return Returns the String
     */
    @JsonGetter("Content-Type")
    public String getContentType() {
        return contentType;
    }

    /**
     * Setter for ContentType.
     * @param contentType Value for String
     */
    @JsonSetter("Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    /**
     * Getter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Mock-Response")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalMockResponse() {
        return paypalMockResponse;
    }

    /**
     * Setter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @param paypalMockResponse Value for String
     */
    @JsonSetter("PayPal-Mock-Response")
    public void setPaypalMockResponse(String paypalMockResponse) {
        this.paypalMockResponse = paypalMockResponse;
    }

    /**
     * Getter for PaypalRequestId.
     * The server stores keys for 45 days.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Request-Id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalRequestId() {
        return paypalRequestId;
    }

    /**
     * Setter for PaypalRequestId.
     * The server stores keys for 45 days.
     * @param paypalRequestId Value for String
     */
    @JsonSetter("PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    /**
     * Getter for Prefer.
     * The preferred server response upon successful completion of the request. Value is:
     * return=minimal. The server returns a minimal response to optimize communication between the
     * API caller and the server. A minimal response includes the id, status and HATEOAS links.
     * return=representation. The server returns a complete resource representation, including the
     * current state of the resource.
     * @return Returns the String
     */
    @JsonGetter("Prefer")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return prefer;
    }

    /**
     * Setter for Prefer.
     * The preferred server response upon successful completion of the request. Value is:
     * return=minimal. The server returns a minimal response to optimize communication between the
     * API caller and the server. A minimal response includes the id, status and HATEOAS links.
     * return=representation. The server returns a complete resource representation, including the
     * current state of the resource.
     * @param prefer Value for String
     */
    @JsonSetter("Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    /**
     * Getter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see
     * [PayPal-Auth-Assertion](/docs/api/reference/api-requests/#paypal-auth-assertion). Note:For
     * three party transactions in which a partner is managing the API calls on behalf of a
     * merchant, the partner must identify the merchant using either a PayPal-Auth-Assertion header
     * or an access token with target_subject.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Auth-Assertion")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return paypalAuthAssertion;
    }

    /**
     * Setter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see
     * [PayPal-Auth-Assertion](/docs/api/reference/api-requests/#paypal-auth-assertion). Note:For
     * three party transactions in which a partner is managing the API calls on behalf of a
     * merchant, the partner must identify the merchant using either a PayPal-Auth-Assertion header
     * or an access token with target_subject.
     * @param paypalAuthAssertion Value for String
     */
    @JsonSetter("PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    /**
     * Getter for Body.
     * @return Returns the RefundRequest
     */
    @JsonGetter("body")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public RefundRequest getBody() {
        return body;
    }

    /**
     * Setter for Body.
     * @param body Value for RefundRequest
     */
    @JsonSetter("body")
    public void setBody(RefundRequest body) {
        this.body = body;
    }

    /**
     * Converts this RefundCapturedPaymentInput into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "RefundCapturedPaymentInput [" + "captureId=" + captureId + ", contentType="
                + contentType + ", paypalMockResponse=" + paypalMockResponse + ", paypalRequestId="
                + paypalRequestId + ", prefer=" + prefer + ", paypalAuthAssertion="
                + paypalAuthAssertion + ", body=" + body + "]";
    }

    /**
     * Builds a new {@link RefundCapturedPaymentInput.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link RefundCapturedPaymentInput.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(captureId, contentType)
                .paypalMockResponse(getPaypalMockResponse())
                .paypalRequestId(getPaypalRequestId())
                .prefer(getPrefer())
                .paypalAuthAssertion(getPaypalAuthAssertion())
                .body(getBody());
        return builder;
    }

    /**
     * Class to build instances of {@link RefundCapturedPaymentInput}.
     */
    public static class Builder {
        private String captureId;
        private String contentType = "application/json";
        private String paypalMockResponse;
        private String paypalRequestId;
        private String prefer = "return=minimal";
        private String paypalAuthAssertion;
        private RefundRequest body;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  captureId  String value for captureId.
         * @param  contentType  String value for contentType.
         */
        public Builder(String captureId, String contentType) {
            this.captureId = captureId;
            this.contentType = contentType;
        }

        /**
         * Setter for captureId.
         * @param  captureId  String value for captureId.
         * @return Builder
         */
        public Builder captureId(String captureId) {
            this.captureId = captureId;
            return this;
        }

        /**
         * Setter for contentType.
         * @param  contentType  String value for contentType.
         * @return Builder
         */
        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Setter for paypalMockResponse.
         * @param  paypalMockResponse  String value for paypalMockResponse.
         * @return Builder
         */
        public Builder paypalMockResponse(String paypalMockResponse) {
            this.paypalMockResponse = paypalMockResponse;
            return this;
        }

        /**
         * Setter for paypalRequestId.
         * @param  paypalRequestId  String value for paypalRequestId.
         * @return Builder
         */
        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        /**
         * Setter for prefer.
         * @param  prefer  String value for prefer.
         * @return Builder
         */
        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        /**
         * Setter for paypalAuthAssertion.
         * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
         * @return Builder
         */
        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        /**
         * Setter for body.
         * @param  body  RefundRequest value for body.
         * @return Builder
         */
        public Builder body(RefundRequest body) {
            this.body = body;
            return this;
        }

        /**
         * Builds a new {@link RefundCapturedPaymentInput} object using the set fields.
         * @return {@link RefundCapturedPaymentInput}
         */
        public RefundCapturedPaymentInput build() {
            return new RefundCapturedPaymentInput(captureId, contentType, paypalMockResponse,
                    paypalRequestId, prefer, paypalAuthAssertion, body);
        }
    }
}
