/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for RefundStatusWithDetails type.
 */
public class RefundStatusWithDetails {
    private RefundStatus status;
    private RefundStatusDetails statusDetails;

    /**
     * Default constructor.
     */
    public RefundStatusWithDetails() {
    }

    /**
     * Initialization constructor.
     * @param  status  RefundStatus value for status.
     * @param  statusDetails  RefundStatusDetails value for statusDetails.
     */
    public RefundStatusWithDetails(
            RefundStatus status,
            RefundStatusDetails statusDetails) {
        this.status = status;
        this.statusDetails = statusDetails;
    }

    /**
     * Getter for Status.
     * The status of the refund.
     * @return Returns the RefundStatus
     */
    @JsonGetter("status")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public RefundStatus getStatus() {
        return status;
    }

    /**
     * Setter for Status.
     * The status of the refund.
     * @param status Value for RefundStatus
     */
    @JsonSetter("status")
    public void setStatus(RefundStatus status) {
        this.status = status;
    }

    /**
     * Getter for StatusDetails.
     * The details of the refund status.
     * @return Returns the RefundStatusDetails
     */
    @JsonGetter("status_details")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public RefundStatusDetails getStatusDetails() {
        return statusDetails;
    }

    /**
     * Setter for StatusDetails.
     * The details of the refund status.
     * @param statusDetails Value for RefundStatusDetails
     */
    @JsonSetter("status_details")
    public void setStatusDetails(RefundStatusDetails statusDetails) {
        this.statusDetails = statusDetails;
    }

    /**
     * Converts this RefundStatusWithDetails into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "RefundStatusWithDetails [" + "status=" + status + ", statusDetails=" + statusDetails
                + "]";
    }

    /**
     * Builds a new {@link RefundStatusWithDetails.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link RefundStatusWithDetails.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .status(getStatus())
                .statusDetails(getStatusDetails());
        return builder;
    }

    /**
     * Class to build instances of {@link RefundStatusWithDetails}.
     */
    public static class Builder {
        private RefundStatus status;
        private RefundStatusDetails statusDetails;



        /**
         * Setter for status.
         * @param  status  RefundStatus value for status.
         * @return Builder
         */
        public Builder status(RefundStatus status) {
            this.status = status;
            return this;
        }

        /**
         * Setter for statusDetails.
         * @param  statusDetails  RefundStatusDetails value for statusDetails.
         * @return Builder
         */
        public Builder statusDetails(RefundStatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        /**
         * Builds a new {@link RefundStatusWithDetails} object using the set fields.
         * @return {@link RefundStatusWithDetails}
         */
        public RefundStatusWithDetails build() {
            return new RefundStatusWithDetails(status, statusDetails);
        }
    }
}
