/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.Money;

public class AmountBreakdown {
    private Money itemTotal;
    private Money shipping;
    private Money handling;
    private Money taxTotal;
    private Money insurance;
    private Money shippingDiscount;
    private Money discount;

    public AmountBreakdown() {
    }

    public AmountBreakdown(Money itemTotal, Money shipping, Money handling, Money taxTotal, Money insurance, Money shippingDiscount, Money discount) {
        this.itemTotal = itemTotal;
        this.shipping = shipping;
        this.handling = handling;
        this.taxTotal = taxTotal;
        this.insurance = insurance;
        this.shippingDiscount = shippingDiscount;
        this.discount = discount;
    }

    @JsonGetter(value="item_total")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getItemTotal() {
        return this.itemTotal;
    }

    @JsonSetter(value="item_total")
    public void setItemTotal(Money itemTotal) {
        this.itemTotal = itemTotal;
    }

    @JsonGetter(value="shipping")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getShipping() {
        return this.shipping;
    }

    @JsonSetter(value="shipping")
    public void setShipping(Money shipping) {
        this.shipping = shipping;
    }

    @JsonGetter(value="handling")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getHandling() {
        return this.handling;
    }

    @JsonSetter(value="handling")
    public void setHandling(Money handling) {
        this.handling = handling;
    }

    @JsonGetter(value="tax_total")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTaxTotal() {
        return this.taxTotal;
    }

    @JsonSetter(value="tax_total")
    public void setTaxTotal(Money taxTotal) {
        this.taxTotal = taxTotal;
    }

    @JsonGetter(value="insurance")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getInsurance() {
        return this.insurance;
    }

    @JsonSetter(value="insurance")
    public void setInsurance(Money insurance) {
        this.insurance = insurance;
    }

    @JsonGetter(value="shipping_discount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getShippingDiscount() {
        return this.shippingDiscount;
    }

    @JsonSetter(value="shipping_discount")
    public void setShippingDiscount(Money shippingDiscount) {
        this.shippingDiscount = shippingDiscount;
    }

    @JsonGetter(value="discount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getDiscount() {
        return this.discount;
    }

    @JsonSetter(value="discount")
    public void setDiscount(Money discount) {
        this.discount = discount;
    }

    public String toString() {
        return "AmountBreakdown [itemTotal=" + this.itemTotal + ", shipping=" + this.shipping + ", handling=" + this.handling + ", taxTotal=" + this.taxTotal + ", insurance=" + this.insurance + ", shippingDiscount=" + this.shippingDiscount + ", discount=" + this.discount + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().itemTotal(this.getItemTotal()).shipping(this.getShipping()).handling(this.getHandling()).taxTotal(this.getTaxTotal()).insurance(this.getInsurance()).shippingDiscount(this.getShippingDiscount()).discount(this.getDiscount());
        return builder;
    }

    public static class Builder {
        private Money itemTotal;
        private Money shipping;
        private Money handling;
        private Money taxTotal;
        private Money insurance;
        private Money shippingDiscount;
        private Money discount;

        public Builder itemTotal(Money itemTotal) {
            this.itemTotal = itemTotal;
            return this;
        }

        public Builder shipping(Money shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder handling(Money handling) {
            this.handling = handling;
            return this;
        }

        public Builder taxTotal(Money taxTotal) {
            this.taxTotal = taxTotal;
            return this;
        }

        public Builder insurance(Money insurance) {
            this.insurance = insurance;
            return this;
        }

        public Builder shippingDiscount(Money shippingDiscount) {
            this.shippingDiscount = shippingDiscount;
            return this;
        }

        public Builder discount(Money discount) {
            this.discount = discount;
            return this;
        }

        public AmountBreakdown build() {
            return new AmountBreakdown(this.itemTotal, this.shipping, this.handling, this.taxTotal, this.insurance, this.shippingDiscount, this.discount);
        }
    }
}

