/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.PaymentInitiator;
import com.paypal.sdk.models.StoredPaymentSourceUsageType;
import com.paypal.sdk.models.UsagePattern;

public class PaypalWalletStoredCredential {
    private PaymentInitiator paymentInitiator;
    private UsagePattern chargePattern;
    private UsagePattern usagePattern;
    private StoredPaymentSourceUsageType usage;

    public PaypalWalletStoredCredential() {
        this.usage = StoredPaymentSourceUsageType.DERIVED;
    }

    public PaypalWalletStoredCredential(PaymentInitiator paymentInitiator, UsagePattern chargePattern, UsagePattern usagePattern, StoredPaymentSourceUsageType usage) {
        this.paymentInitiator = paymentInitiator;
        this.chargePattern = chargePattern;
        this.usagePattern = usagePattern;
        this.usage = usage;
    }

    @JsonGetter(value="payment_initiator")
    public PaymentInitiator getPaymentInitiator() {
        return this.paymentInitiator;
    }

    @JsonSetter(value="payment_initiator")
    public void setPaymentInitiator(PaymentInitiator paymentInitiator) {
        this.paymentInitiator = paymentInitiator;
    }

    @JsonGetter(value="charge_pattern")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public UsagePattern getChargePattern() {
        return this.chargePattern;
    }

    @JsonSetter(value="charge_pattern")
    public void setChargePattern(UsagePattern chargePattern) {
        this.chargePattern = chargePattern;
    }

    @JsonGetter(value="usage_pattern")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public UsagePattern getUsagePattern() {
        return this.usagePattern;
    }

    @JsonSetter(value="usage_pattern")
    public void setUsagePattern(UsagePattern usagePattern) {
        this.usagePattern = usagePattern;
    }

    @JsonGetter(value="usage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public StoredPaymentSourceUsageType getUsage() {
        return this.usage;
    }

    @JsonSetter(value="usage")
    public void setUsage(StoredPaymentSourceUsageType usage) {
        this.usage = usage;
    }

    public String toString() {
        return "PaypalWalletStoredCredential [paymentInitiator=" + (Object)((Object)this.paymentInitiator) + ", chargePattern=" + (Object)((Object)this.chargePattern) + ", usagePattern=" + (Object)((Object)this.usagePattern) + ", usage=" + (Object)((Object)this.usage) + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.paymentInitiator).chargePattern(this.getChargePattern()).usagePattern(this.getUsagePattern()).usage(this.getUsage());
        return builder;
    }

    public static class Builder {
        private PaymentInitiator paymentInitiator;
        private UsagePattern chargePattern;
        private UsagePattern usagePattern;
        private StoredPaymentSourceUsageType usage = StoredPaymentSourceUsageType.DERIVED;

        public Builder() {
        }

        public Builder(PaymentInitiator paymentInitiator) {
            this.paymentInitiator = paymentInitiator;
        }

        public Builder paymentInitiator(PaymentInitiator paymentInitiator) {
            this.paymentInitiator = paymentInitiator;
            return this;
        }

        public Builder chargePattern(UsagePattern chargePattern) {
            this.chargePattern = chargePattern;
            return this;
        }

        public Builder usagePattern(UsagePattern usagePattern) {
            this.usagePattern = usagePattern;
            return this;
        }

        public Builder usage(StoredPaymentSourceUsageType usage) {
            this.usage = usage;
            return this;
        }

        public PaypalWalletStoredCredential build() {
            return new PaypalWalletStoredCredential(this.paymentInitiator, this.chargePattern, this.usagePattern, this.usage);
        }
    }
}

