/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.Money;
import com.paypal.sdk.models.PayeeBase;

public class PlatformFee {
    private Money amount;
    private PayeeBase payee;

    public PlatformFee() {
    }

    public PlatformFee(Money amount, PayeeBase payee) {
        this.amount = amount;
        this.payee = payee;
    }

    @JsonGetter(value="amount")
    public Money getAmount() {
        return this.amount;
    }

    @JsonSetter(value="amount")
    public void setAmount(Money amount) {
        this.amount = amount;
    }

    @JsonGetter(value="payee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PayeeBase getPayee() {
        return this.payee;
    }

    @JsonSetter(value="payee")
    public void setPayee(PayeeBase payee) {
        this.payee = payee;
    }

    public String toString() {
        return "PlatformFee [amount=" + this.amount + ", payee=" + this.payee + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.amount).payee(this.getPayee());
        return builder;
    }

    public static class Builder {
        private Money amount;
        private PayeeBase payee;

        public Builder() {
        }

        public Builder(Money amount) {
            this.amount = amount;
        }

        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        public Builder payee(PayeeBase payee) {
            this.payee = payee;
            return this;
        }

        public PlatformFee build() {
            return new PlatformFee(this.amount, this.payee);
        }
    }
}

