/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.RefundRequest;

public class RefundCapturedPaymentInput {
    private String captureId;
    private String contentType;
    private String paypalMockResponse;
    private String paypalRequestId;
    private String prefer;
    private String paypalAuthAssertion;
    private RefundRequest body;

    public RefundCapturedPaymentInput() {
        this.contentType = "application/json";
        this.prefer = "return=minimal";
    }

    public RefundCapturedPaymentInput(String captureId, String contentType, String paypalMockResponse, String paypalRequestId, String prefer, String paypalAuthAssertion, RefundRequest body) {
        this.captureId = captureId;
        this.contentType = contentType;
        this.paypalMockResponse = paypalMockResponse;
        this.paypalRequestId = paypalRequestId;
        this.prefer = prefer;
        this.paypalAuthAssertion = paypalAuthAssertion;
        this.body = body;
    }

    @JsonGetter(value="capture_id")
    public String getCaptureId() {
        return this.captureId;
    }

    @JsonSetter(value="capture_id")
    public void setCaptureId(String captureId) {
        this.captureId = captureId;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="PayPal-Mock-Response")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalMockResponse() {
        return this.paypalMockResponse;
    }

    @JsonSetter(value="PayPal-Mock-Response")
    public void setPaypalMockResponse(String paypalMockResponse) {
        this.paypalMockResponse = paypalMockResponse;
    }

    @JsonGetter(value="PayPal-Request-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalRequestId() {
        return this.paypalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    @JsonGetter(value="Prefer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return this.prefer;
    }

    @JsonSetter(value="Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    @JsonGetter(value="PayPal-Auth-Assertion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return this.paypalAuthAssertion;
    }

    @JsonSetter(value="PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    @JsonGetter(value="body")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public RefundRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(RefundRequest body) {
        this.body = body;
    }

    public String toString() {
        return "RefundCapturedPaymentInput [captureId=" + this.captureId + ", contentType=" + this.contentType + ", paypalMockResponse=" + this.paypalMockResponse + ", paypalRequestId=" + this.paypalRequestId + ", prefer=" + this.prefer + ", paypalAuthAssertion=" + this.paypalAuthAssertion + ", body=" + this.body + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.captureId, this.contentType).paypalMockResponse(this.getPaypalMockResponse()).paypalRequestId(this.getPaypalRequestId()).prefer(this.getPrefer()).paypalAuthAssertion(this.getPaypalAuthAssertion()).body(this.getBody());
        return builder;
    }

    public static class Builder {
        private String captureId;
        private String contentType = "application/json";
        private String paypalMockResponse;
        private String paypalRequestId;
        private String prefer = "return=minimal";
        private String paypalAuthAssertion;
        private RefundRequest body;

        public Builder() {
        }

        public Builder(String captureId, String contentType) {
            this.captureId = captureId;
            this.contentType = contentType;
        }

        public Builder captureId(String captureId) {
            this.captureId = captureId;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder paypalMockResponse(String paypalMockResponse) {
            this.paypalMockResponse = paypalMockResponse;
            return this;
        }

        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        public Builder body(RefundRequest body) {
            this.body = body;
            return this;
        }

        public RefundCapturedPaymentInput build() {
            return new RefundCapturedPaymentInput(this.captureId, this.contentType, this.paypalMockResponse, this.paypalRequestId, this.prefer, this.paypalAuthAssertion, this.body);
        }
    }
}

