/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.CardSupplementaryData;
import com.paypal.sdk.models.RiskSupplementaryData;

public class SupplementaryData {
    private CardSupplementaryData card;
    private RiskSupplementaryData risk;

    public SupplementaryData() {
    }

    public SupplementaryData(CardSupplementaryData card, RiskSupplementaryData risk) {
        this.card = card;
        this.risk = risk;
    }

    @JsonGetter(value="card")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CardSupplementaryData getCard() {
        return this.card;
    }

    @JsonSetter(value="card")
    public void setCard(CardSupplementaryData card) {
        this.card = card;
    }

    @JsonGetter(value="risk")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public RiskSupplementaryData getRisk() {
        return this.risk;
    }

    @JsonSetter(value="risk")
    public void setRisk(RiskSupplementaryData risk) {
        this.risk = risk;
    }

    public String toString() {
        return "SupplementaryData [card=" + this.card + ", risk=" + this.risk + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().card(this.getCard()).risk(this.getRisk());
        return builder;
    }

    public static class Builder {
        private CardSupplementaryData card;
        private RiskSupplementaryData risk;

        public Builder card(CardSupplementaryData card) {
            this.card = card;
            return this;
        }

        public Builder risk(RiskSupplementaryData risk) {
            this.risk = risk;
            return this;
        }

        public SupplementaryData build() {
            return new SupplementaryData(this.card, this.risk);
        }
    }
}

