/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum TaxIdType {
    BR_CPF,
    BR_CNPJ,
    _UNKNOWN;

    private static TreeMap<String, TaxIdType> valueMap;
    private String value;

    @JsonCreator
    public static TaxIdType constructFromString(String toConvert) throws IOException {
        TaxIdType enumValue = TaxIdType.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static TaxIdType fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public static List<String> toValue(List<TaxIdType> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (TaxIdType enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        TaxIdType.BR_CPF.value = "BR_CPF";
        TaxIdType.BR_CNPJ.value = "BR_CNPJ";
        TaxIdType._UNKNOWN.value = null;
        valueMap.put("BR_CPF", BR_CPF);
        valueMap.put("BR_CNPJ", BR_CNPJ);
    }
}

