/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class VoidPaymentInput {
    private String authorizationId;
    private String paypalMockResponse;
    private String paypalAuthAssertion;
    private String paypalRequestId;
    private String prefer;

    public VoidPaymentInput() {
        this.prefer = "return=minimal";
    }

    public VoidPaymentInput(String authorizationId, String paypalMockResponse, String paypalAuthAssertion, String paypalRequestId, String prefer) {
        this.authorizationId = authorizationId;
        this.paypalMockResponse = paypalMockResponse;
        this.paypalAuthAssertion = paypalAuthAssertion;
        this.paypalRequestId = paypalRequestId;
        this.prefer = prefer;
    }

    @JsonGetter(value="authorization_id")
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    @JsonSetter(value="authorization_id")
    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    @JsonGetter(value="PayPal-Mock-Response")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalMockResponse() {
        return this.paypalMockResponse;
    }

    @JsonSetter(value="PayPal-Mock-Response")
    public void setPaypalMockResponse(String paypalMockResponse) {
        this.paypalMockResponse = paypalMockResponse;
    }

    @JsonGetter(value="PayPal-Auth-Assertion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return this.paypalAuthAssertion;
    }

    @JsonSetter(value="PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    @JsonGetter(value="PayPal-Request-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalRequestId() {
        return this.paypalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    @JsonGetter(value="Prefer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return this.prefer;
    }

    @JsonSetter(value="Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    public String toString() {
        return "VoidPaymentInput [authorizationId=" + this.authorizationId + ", paypalMockResponse=" + this.paypalMockResponse + ", paypalAuthAssertion=" + this.paypalAuthAssertion + ", paypalRequestId=" + this.paypalRequestId + ", prefer=" + this.prefer + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.authorizationId).paypalMockResponse(this.getPaypalMockResponse()).paypalAuthAssertion(this.getPaypalAuthAssertion()).paypalRequestId(this.getPaypalRequestId()).prefer(this.getPrefer());
        return builder;
    }

    public static class Builder {
        private String authorizationId;
        private String paypalMockResponse;
        private String paypalAuthAssertion;
        private String paypalRequestId;
        private String prefer = "return=minimal";

        public Builder() {
        }

        public Builder(String authorizationId) {
            this.authorizationId = authorizationId;
        }

        public Builder authorizationId(String authorizationId) {
            this.authorizationId = authorizationId;
            return this;
        }

        public Builder paypalMockResponse(String paypalMockResponse) {
            this.paypalMockResponse = paypalMockResponse;
            return this;
        }

        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        public VoidPaymentInput build() {
            return new VoidPaymentInput(this.authorizationId, this.paypalMockResponse, this.paypalAuthAssertion, this.paypalRequestId, this.prefer);
        }
    }
}

