/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.logging.configuration;

import java.util.List;

import io.apimatic.core.logger.configurations.SdkRequestLoggingConfiguration;
import io.apimatic.coreinterfaces.logger.configuration.RequestLoggingConfiguration;

/**
 * Class to hold request logging configuration.
 */
public class ApiRequestLoggingConfiguration implements ReadonlyRequestLoggingConfiguration {

    private final RequestLoggingConfiguration requestConfig;
    
    private ApiRequestLoggingConfiguration(SdkRequestLoggingConfiguration.Builder builder) {
        requestConfig = builder.build();
    }

    /**
     * Checks if logging of request body is enabled.
     * @return True if logging of request body is enabled, otherwise false.
     */
    public boolean shouldLogBody() {
        return requestConfig.shouldLogBody();
    }

    /**
     * Checks if logging of request headers is enabled.
     * @return True if logging of request headers is enabled, otherwise false.
     */
    public boolean shouldLogHeaders() {
        return requestConfig.shouldLogHeaders();
    }

    /**
     * Gets the list of headers to include in logging.
     * @return An unmodifiable list of headers to include.
     */
    public List<String> getHeadersToInclude() {
        return requestConfig.getHeadersToInclude();
    }

    /**
     * Gets the list of headers to exclude from logging.
     * @return An unmodifiable list of headers to exclude.
     */
    public List<String> getHeadersToExclude() {
        return requestConfig.getHeadersToExclude();
    }

    /**
     * Retrieves the list of headers to unmask from sensitive headers. These
     * headers are excluded from masking.
     * @return An unmodifiable list of headers to unmasked.
     */
    public List<String> getHeadersToUnmask() {
        return requestConfig.getHeadersToUnmask();
    }

    
    /**
     * Checks if query parameters are included in the request path.
     * @return True if query parameters are included in the path, otherwise false.
     */
    public boolean shouldIncludeQueryInPath() {
        return requestConfig.shouldIncludeQueryInPath();
    }

    /**
     * Converts {@link ApiRequestLoggingConfiguration} into string format.
     * @return String representation of this class.
     */
    @Override
    public String toString() {
        return "ApiRequestLoggingConfiguration [logBody=" + shouldLogBody() + " logHeaders="
                + shouldLogHeaders() + " includeQueryInPath=" + shouldIncludeQueryInPath()
                + " excludeHeaders=" + getHeadersToExclude() + " includeHeaders="
                + getHeadersToInclude() + " unmaskHeaders=" + getHeadersToUnmask() + "]";
    }

    /**
     * Builds a new {@link ApiRequestLoggingConfiguration.Builder} object. Creates the instance
     * with the current state.
     * @return a new {@link ApiRequestLoggingConfiguration.Builder} object.
     */
    public Builder newBuilder() {
        return new Builder().body(shouldLogBody()).headers(shouldLogHeaders())
                .excludeHeaders(getHeadersToExclude().toArray(new String[0]))
                .includeHeaders(getHeadersToInclude().toArray(new String[0]))
                .unmaskHeaders(getHeadersToUnmask().toArray(new String[0]))
                .includeQueryInPath(shouldIncludeQueryInPath());
    }

    /**
     * Builder class for ApiRequestLoggingConfiguration.
     */
    public static class Builder {
        private SdkRequestLoggingConfiguration.Builder builder =
                new SdkRequestLoggingConfiguration.Builder();

        /**
         * Sets whether to log the body.
         * @param logBody True to log the body, otherwise false.
         * @return The builder instance.
         */
        public Builder body(boolean logBody) {
            builder.body(logBody);
            return this;
        }

        /**
         * Sets whether to log the headers.
         * @param logHeaders True to log the headers, otherwise false.
         * @return The builder instance.
         */
        public Builder headers(boolean logHeaders) {
            builder.headers(logHeaders);
            return this;
        }

        /**
         * Sets the headers to be excluded from logging.
         * @param excludeHeaders The headers to exclude.
         * @return The builder instance.
         */
        public Builder excludeHeaders(String... excludeHeaders) {
            builder.excludeHeaders(excludeHeaders);
            return this;
        }

        /**
         * Sets the headers to be included in logging.
         * @param includeHeaders The headers to include.
         * @return The builder instance.
         */
        public Builder includeHeaders(String... includeHeaders) {
            builder.includeHeaders(includeHeaders);
            return this;
        }

        /**
         * Sets the headers to be unmasked in logging.
         * @param unmaskHeaders The headers to unmask in logging.
         * @return The builder instance.
         */
        public Builder unmaskHeaders(String... unmaskHeaders) {
            builder.unmaskHeaders(unmaskHeaders);
            return this;
        }
        
        /**
         * Sets whether to include query parameters in the request path.
         * @param includeQueryInPath True to include query parameters in the path,
         *                           otherwise false.
         * @return The builder instance.
         */
        public Builder includeQueryInPath(boolean includeQueryInPath) {
            builder.includeQueryInPath(includeQueryInPath);
            return this;
        }

        /**
         * Constructs a ApiRequestLoggingConfiguration object with the set values.
         * @return The constructed RequestConfiguration object.
         */
        public ApiRequestLoggingConfiguration build() {
            return new ApiRequestLoggingConfiguration(builder);
        }
    }
}