/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.logging.configuration;

import java.util.List;

import io.apimatic.core.logger.configurations.SdkResponseLoggingConfiguration;
import io.apimatic.coreinterfaces.logger.configuration.ResponseLoggingConfiguration;

/**
 * Class to hold response logging configuration.
 */
public class ApiResponseLoggingConfiguration implements ReadonlyResponseLoggingConfiguration {

    private final ResponseLoggingConfiguration responseConfig;
    
    private ApiResponseLoggingConfiguration(SdkResponseLoggingConfiguration.Builder builder) {
        responseConfig = builder.build();
    }

    /**
     * Checks if logging of request body is enabled.
     * @return True if logging of request body is enabled, otherwise false.
     */
    public boolean shouldLogBody() {
        return responseConfig.shouldLogBody();
    }

    /**
     * Checks if logging of request headers is enabled.
     * @return True if logging of request headers is enabled, otherwise false.
     */
    public boolean shouldLogHeaders() {
        return responseConfig.shouldLogHeaders();
    }

    /**
     * Gets the list of headers to include in logging.
     * @return An unmodifiable list of headers to include.
     */
    public List<String> getHeadersToInclude() {
        return responseConfig.getHeadersToInclude();
    }

    /**
     * Gets the list of headers to exclude from logging.
     * @return An unmodifiable list of headers to exclude.
     */
    public List<String> getHeadersToExclude() {
        return responseConfig.getHeadersToExclude();
    }

    /**
     * Retrieves the list of headers to unmask from sensitive headers. These
     * headers are excluded from masking.
     * @return An unmodifiable list of headers to unmasked.
     */
    public List<String> getHeadersToUnmask() {
        return responseConfig.getHeadersToUnmask();
    }

    /**
     * Converts {@link ApiResponseLoggingConfiguration} into string format.
     * @return String representation of this class.
     */
    @Override
    public String toString() {
        return "ApiResponseLoggingConfiguration [logBody=" + shouldLogBody() + " logHeaders="
                + shouldLogHeaders() + " excludeHeaders=" + getHeadersToExclude()
                + " includeHeaders=" + getHeadersToInclude()
                + " unmaskHeaders=" + getHeadersToUnmask() + "]";
    }

    /**
     * Builds a new {@link ApiResponseLoggingConfiguration.Builder} object. Creates the instance
     * with the current state.
     * @return a new {@link ApiResponseLoggingConfiguration.Builder} object.
     */
    public Builder newBuilder() {
        return new Builder().body(shouldLogBody()).headers(shouldLogHeaders())
                .excludeHeaders(getHeadersToExclude().toArray(new String[0]))
                .includeHeaders(getHeadersToInclude().toArray(new String[0]))
                .unmaskHeaders(getHeadersToUnmask().toArray(new String[0]));
    }

    /**
     * Builder class for RequestLoggingConfiguration.
     */
    public static class Builder {
        private SdkResponseLoggingConfiguration.Builder builder =
                new SdkResponseLoggingConfiguration.Builder();

        /**
         * Sets whether to log the body.
         * @param logBody True to log the body, otherwise false.
         * @return The builder instance.
         */
        public Builder body(boolean logBody) {
            builder.body(logBody);
            return this;
        }

        /**
         * Sets whether to log the headers.
         * @param logHeaders True to log the headers, otherwise false.
         * @return The builder instance.
         */
        public Builder headers(boolean logHeaders) {
            builder.headers(logHeaders);
            return this;
        }

        /**
         * Sets the headers to be excluded from logging.
         * @param excludeHeaders The headers to exclude.
         * @return The builder instance.
         */
        public Builder excludeHeaders(String... excludeHeaders) {
            builder.excludeHeaders(excludeHeaders);
            return this;
        }

        /**
         * Sets the headers to be included in logging.
         * @param includeHeaders The headers to include.
         * @return The builder instance.
         */
        public Builder includeHeaders(String... includeHeaders) {
            builder.includeHeaders(includeHeaders);
            return this;
        }

        /**
         * Sets the headers to be unmasked in logging.
         * @param unmaskHeaders The headers to unmask in logging.
         * @return The builder instance.
         */
        public Builder unmaskHeaders(String... unmaskHeaders) {
            builder.unmaskHeaders(unmaskHeaders);
            return this;
        }

        /**
         * Constructs a RequestLoggingConfiguration object with the set values.
         * @return The constructed {@link ApiResponseLoggingConfiguration} object.
         */
        public ApiResponseLoggingConfiguration build() {
            return new ApiResponseLoggingConfiguration(builder);
        }
    }
}