/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for BlikOneClickPaymentRequest type.
 */
public class BlikOneClickPaymentRequest {
    private String authCode;
    private String consumerReference;
    private String aliasLabel;
    private String aliasKey;

    /**
     * Default constructor.
     */
    public BlikOneClickPaymentRequest() {
    }

    /**
     * Initialization constructor.
     * @param  consumerReference  String value for consumerReference.
     * @param  authCode  String value for authCode.
     * @param  aliasLabel  String value for aliasLabel.
     * @param  aliasKey  String value for aliasKey.
     */
    public BlikOneClickPaymentRequest(
            String consumerReference,
            String authCode,
            String aliasLabel,
            String aliasKey) {
        this.authCode = authCode;
        this.consumerReference = consumerReference;
        this.aliasLabel = aliasLabel;
        this.aliasKey = aliasKey;
    }

    /**
     * Getter for AuthCode.
     * The 6-digit code used to authenticate a consumer within BLIK.
     * @return Returns the String
     */
    @JsonGetter("auth_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getAuthCode() {
        return authCode;
    }

    /**
     * Setter for AuthCode.
     * The 6-digit code used to authenticate a consumer within BLIK.
     * @param authCode Value for String
     */
    @JsonSetter("auth_code")
    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    /**
     * Getter for ConsumerReference.
     * The merchant generated, unique reference serving as a primary identifier for accounts
     * connected between Blik and a merchant.
     * @return Returns the String
     */
    @JsonGetter("consumer_reference")
    public String getConsumerReference() {
        return consumerReference;
    }

    /**
     * Setter for ConsumerReference.
     * The merchant generated, unique reference serving as a primary identifier for accounts
     * connected between Blik and a merchant.
     * @param consumerReference Value for String
     */
    @JsonSetter("consumer_reference")
    public void setConsumerReference(String consumerReference) {
        this.consumerReference = consumerReference;
    }

    /**
     * Getter for AliasLabel.
     * A bank defined identifier used as a display name to allow the payer to differentiate between
     * multiple registered bank accounts.
     * @return Returns the String
     */
    @JsonGetter("alias_label")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getAliasLabel() {
        return aliasLabel;
    }

    /**
     * Setter for AliasLabel.
     * A bank defined identifier used as a display name to allow the payer to differentiate between
     * multiple registered bank accounts.
     * @param aliasLabel Value for String
     */
    @JsonSetter("alias_label")
    public void setAliasLabel(String aliasLabel) {
        this.aliasLabel = aliasLabel;
    }

    /**
     * Getter for AliasKey.
     * A Blik-defined identifier for a specific Blik-enabled bank account that is associated with a
     * given merchant. Used only in conjunction with a Consumer Reference.
     * @return Returns the String
     */
    @JsonGetter("alias_key")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getAliasKey() {
        return aliasKey;
    }

    /**
     * Setter for AliasKey.
     * A Blik-defined identifier for a specific Blik-enabled bank account that is associated with a
     * given merchant. Used only in conjunction with a Consumer Reference.
     * @param aliasKey Value for String
     */
    @JsonSetter("alias_key")
    public void setAliasKey(String aliasKey) {
        this.aliasKey = aliasKey;
    }

    /**
     * Converts this BlikOneClickPaymentRequest into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "BlikOneClickPaymentRequest [" + "consumerReference=" + consumerReference
                + ", authCode=" + authCode + ", aliasLabel=" + aliasLabel + ", aliasKey=" + aliasKey
                + "]";
    }

    /**
     * Builds a new {@link BlikOneClickPaymentRequest.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link BlikOneClickPaymentRequest.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(consumerReference)
                .authCode(getAuthCode())
                .aliasLabel(getAliasLabel())
                .aliasKey(getAliasKey());
        return builder;
    }

    /**
     * Class to build instances of {@link BlikOneClickPaymentRequest}.
     */
    public static class Builder {
        private String consumerReference;
        private String authCode;
        private String aliasLabel;
        private String aliasKey;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  consumerReference  String value for consumerReference.
         */
        public Builder(String consumerReference) {
            this.consumerReference = consumerReference;
        }

        /**
         * Setter for consumerReference.
         * @param  consumerReference  String value for consumerReference.
         * @return Builder
         */
        public Builder consumerReference(String consumerReference) {
            this.consumerReference = consumerReference;
            return this;
        }

        /**
         * Setter for authCode.
         * @param  authCode  String value for authCode.
         * @return Builder
         */
        public Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        /**
         * Setter for aliasLabel.
         * @param  aliasLabel  String value for aliasLabel.
         * @return Builder
         */
        public Builder aliasLabel(String aliasLabel) {
            this.aliasLabel = aliasLabel;
            return this;
        }

        /**
         * Setter for aliasKey.
         * @param  aliasKey  String value for aliasKey.
         * @return Builder
         */
        public Builder aliasKey(String aliasKey) {
            this.aliasKey = aliasKey;
            return this;
        }

        /**
         * Builds a new {@link BlikOneClickPaymentRequest} object using the set fields.
         * @return {@link BlikOneClickPaymentRequest}
         */
        public BlikOneClickPaymentRequest build() {
            return new BlikOneClickPaymentRequest(consumerReference, authCode, aliasLabel,
                    aliasKey);
        }
    }
}
