/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for ConfirmOrderInput type.
 */
public class ConfirmOrderInput {
    private String id;
    private String contentType;
    private String paypalClientMetadataId;
    private String paypalAuthAssertion;
    private String prefer;
    private ConfirmOrderRequest body;

    /**
     * Default constructor.
     */
    public ConfirmOrderInput() {
        contentType = "application/json";
        prefer = "return=minimal";
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  contentType  String value for contentType.
     * @param  paypalClientMetadataId  String value for paypalClientMetadataId.
     * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
     * @param  prefer  String value for prefer.
     * @param  body  ConfirmOrderRequest value for body.
     */
    public ConfirmOrderInput(
            String id,
            String contentType,
            String paypalClientMetadataId,
            String paypalAuthAssertion,
            String prefer,
            ConfirmOrderRequest body) {
        this.id = id;
        this.contentType = contentType;
        this.paypalClientMetadataId = paypalClientMetadataId;
        this.paypalAuthAssertion = paypalAuthAssertion;
        this.prefer = prefer;
        this.body = body;
    }

    /**
     * Getter for Id.
     * The ID of the order for which the payer confirms their intent to pay.
     * @return Returns the String
     */
    @JsonGetter("id")
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * The ID of the order for which the payer confirms their intent to pay.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for ContentType.
     * @return Returns the String
     */
    @JsonGetter("Content-Type")
    public String getContentType() {
        return contentType;
    }

    /**
     * Setter for ContentType.
     * @param contentType Value for String
     */
    @JsonSetter("Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    /**
     * Getter for PaypalClientMetadataId.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Client-Metadata-Id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalClientMetadataId() {
        return paypalClientMetadataId;
    }

    /**
     * Setter for PaypalClientMetadataId.
     * @param paypalClientMetadataId Value for String
     */
    @JsonSetter("PayPal-Client-Metadata-Id")
    public void setPaypalClientMetadataId(String paypalClientMetadataId) {
        this.paypalClientMetadataId = paypalClientMetadataId;
    }

    /**
     * Getter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see PayPal-Auth-Assertion.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Auth-Assertion")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return paypalAuthAssertion;
    }

    /**
     * Setter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see PayPal-Auth-Assertion.
     * @param paypalAuthAssertion Value for String
     */
    @JsonSetter("PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    /**
     * Getter for Prefer.
     * The preferred server response upon successful completion of the request. Value is:
     * return=minimal. The server returns a minimal response to optimize communication between the
     * API caller and the server. A minimal response includes the id, status and HATEOAS links.
     * return=representation. The server returns a complete resource representation, including the
     * current state of the resource.
     * @return Returns the String
     */
    @JsonGetter("Prefer")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return prefer;
    }

    /**
     * Setter for Prefer.
     * The preferred server response upon successful completion of the request. Value is:
     * return=minimal. The server returns a minimal response to optimize communication between the
     * API caller and the server. A minimal response includes the id, status and HATEOAS links.
     * return=representation. The server returns a complete resource representation, including the
     * current state of the resource.
     * @param prefer Value for String
     */
    @JsonSetter("Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    /**
     * Getter for Body.
     * @return Returns the ConfirmOrderRequest
     */
    @JsonGetter("body")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ConfirmOrderRequest getBody() {
        return body;
    }

    /**
     * Setter for Body.
     * @param body Value for ConfirmOrderRequest
     */
    @JsonSetter("body")
    public void setBody(ConfirmOrderRequest body) {
        this.body = body;
    }

    /**
     * Converts this ConfirmOrderInput into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "ConfirmOrderInput [" + "id=" + id + ", contentType=" + contentType
                + ", paypalClientMetadataId=" + paypalClientMetadataId + ", paypalAuthAssertion="
                + paypalAuthAssertion + ", prefer=" + prefer + ", body=" + body + "]";
    }

    /**
     * Builds a new {@link ConfirmOrderInput.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link ConfirmOrderInput.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(id, contentType)
                .paypalClientMetadataId(getPaypalClientMetadataId())
                .paypalAuthAssertion(getPaypalAuthAssertion())
                .prefer(getPrefer())
                .body(getBody());
        return builder;
    }

    /**
     * Class to build instances of {@link ConfirmOrderInput}.
     */
    public static class Builder {
        private String id;
        private String contentType = "application/json";
        private String paypalClientMetadataId;
        private String paypalAuthAssertion;
        private String prefer = "return=minimal";
        private ConfirmOrderRequest body;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  id  String value for id.
         * @param  contentType  String value for contentType.
         */
        public Builder(String id, String contentType) {
            this.id = id;
            this.contentType = contentType;
        }

        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for contentType.
         * @param  contentType  String value for contentType.
         * @return Builder
         */
        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Setter for paypalClientMetadataId.
         * @param  paypalClientMetadataId  String value for paypalClientMetadataId.
         * @return Builder
         */
        public Builder paypalClientMetadataId(String paypalClientMetadataId) {
            this.paypalClientMetadataId = paypalClientMetadataId;
            return this;
        }

        /**
         * Setter for paypalAuthAssertion.
         * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
         * @return Builder
         */
        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        /**
         * Setter for prefer.
         * @param  prefer  String value for prefer.
         * @return Builder
         */
        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        /**
         * Setter for body.
         * @param  body  ConfirmOrderRequest value for body.
         * @return Builder
         */
        public Builder body(ConfirmOrderRequest body) {
            this.body = body;
            return this;
        }

        /**
         * Builds a new {@link ConfirmOrderInput} object using the set fields.
         * @return {@link ConfirmOrderInput}
         */
        public ConfirmOrderInput build() {
            return new ConfirmOrderInput(id, contentType, paypalClientMetadataId,
                    paypalAuthAssertion, prefer, body);
        }
    }
}
