/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * EciFlag to be used.
 */
public enum EciFlag {
    /**
     * Mastercard non-3-D Secure transaction.
     */
    MASTERCARD_NON_3D_SECURE_TRANSACTION,

    /**
     * Mastercard attempted authentication transaction.
     */
    MASTERCARD_ATTEMPTED_AUTHENTICATION_TRANSACTION,

    /**
     * Mastercard fully authenticated transaction.
     */
    MASTERCARD_FULLY_AUTHENTICATED_TRANSACTION,

    /**
     * VISA, AMEX, JCB, DINERS CLUB fully authenticated transaction.
     */
    FULLY_AUTHENTICATED_TRANSACTION,

    /**
     * VISA, AMEX, JCB, DINERS CLUB attempted authentication transaction.
     */
    ATTEMPTED_AUTHENTICATION_TRANSACTION,

    /**
     * VISA, AMEX, JCB, DINERS CLUB non-3-D Secure transaction.
     */
    NON_3D_SECURE_TRANSACTION,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, EciFlag> valueMap = new TreeMap<>();
    private String value;

    static {
        MASTERCARD_NON_3D_SECURE_TRANSACTION.value = "MASTERCARD_NON_3D_SECURE_TRANSACTION";
        MASTERCARD_ATTEMPTED_AUTHENTICATION_TRANSACTION.value = "MASTERCARD_ATTEMPTED_AUTHENTICATION_TRANSACTION";
        MASTERCARD_FULLY_AUTHENTICATED_TRANSACTION.value = "MASTERCARD_FULLY_AUTHENTICATED_TRANSACTION";
        FULLY_AUTHENTICATED_TRANSACTION.value = "FULLY_AUTHENTICATED_TRANSACTION";
        ATTEMPTED_AUTHENTICATION_TRANSACTION.value = "ATTEMPTED_AUTHENTICATION_TRANSACTION";
        NON_3D_SECURE_TRANSACTION.value = "NON_3D_SECURE_TRANSACTION";
        _UNKNOWN.value = null;

        valueMap.put("MASTERCARD_NON_3D_SECURE_TRANSACTION", MASTERCARD_NON_3D_SECURE_TRANSACTION);
        valueMap.put("MASTERCARD_ATTEMPTED_AUTHENTICATION_TRANSACTION", MASTERCARD_ATTEMPTED_AUTHENTICATION_TRANSACTION);
        valueMap.put("MASTERCARD_FULLY_AUTHENTICATED_TRANSACTION", MASTERCARD_FULLY_AUTHENTICATED_TRANSACTION);
        valueMap.put("FULLY_AUTHENTICATED_TRANSACTION", FULLY_AUTHENTICATED_TRANSACTION);
        valueMap.put("ATTEMPTED_AUTHENTICATION_TRANSACTION", ATTEMPTED_AUTHENTICATION_TRANSACTION);
        valueMap.put("NON_3D_SECURE_TRANSACTION", NON_3D_SECURE_TRANSACTION);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static EciFlag constructFromString(String toConvert) throws IOException {
        EciFlag enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static EciFlag fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of EciFlag values to list of string values.
     * @param toConvert The list of EciFlag values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<EciFlag> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (EciFlag enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 