/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * GooglePayAuthenticationMethod to be used.
 */
public enum GooglePayAuthenticationMethod {
    /**
     * This authentication method is associated with payment cards stored on file with the user's Google Account. Returned payment data includes primary account number (PAN) with the expiration month and the expiration year.
     */
    PAN_ONLY,

    /**
     * Returned payment data includes a 3-D Secure (3DS) cryptogram generated on the device. -&gt; If authentication_method=CRYPTOGRAM, it is required that 'cryptogram' parameter in the request has a valid 3-D Secure (3DS) cryptogram generated on the device.
     */
    CRYPTOGRAM_3DS,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, GooglePayAuthenticationMethod> valueMap = new TreeMap<>();
    private String value;

    static {
        PAN_ONLY.value = "PAN_ONLY";
        CRYPTOGRAM_3DS.value = "CRYPTOGRAM_3DS";
        _UNKNOWN.value = null;

        valueMap.put("PAN_ONLY", PAN_ONLY);
        valueMap.put("CRYPTOGRAM_3DS", CRYPTOGRAM_3DS);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static GooglePayAuthenticationMethod constructFromString(String toConvert) throws IOException {
        GooglePayAuthenticationMethod enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static GooglePayAuthenticationMethod fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of GooglePayAuthenticationMethod values to list of string values.
     * @param toConvert The list of GooglePayAuthenticationMethod values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<GooglePayAuthenticationMethod> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (GooglePayAuthenticationMethod enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 