/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for GooglePayRequest type.
 */
public class GooglePayRequest {
    private String name;
    private String emailAddress;
    private PhoneNumberWithCountryCode phoneNumber;
    private GooglePayRequestCard card;
    private GooglePayDecryptedTokenData decryptedToken;
    private AssuranceDetails assuranceDetails;
    private GooglePayExperienceContext experienceContext;

    /**
     * Default constructor.
     */
    public GooglePayRequest() {
    }

    /**
     * Initialization constructor.
     * @param  name  String value for name.
     * @param  emailAddress  String value for emailAddress.
     * @param  phoneNumber  PhoneNumberWithCountryCode value for phoneNumber.
     * @param  card  GooglePayRequestCard value for card.
     * @param  decryptedToken  GooglePayDecryptedTokenData value for decryptedToken.
     * @param  assuranceDetails  AssuranceDetails value for assuranceDetails.
     * @param  experienceContext  GooglePayExperienceContext value for experienceContext.
     */
    public GooglePayRequest(
            String name,
            String emailAddress,
            PhoneNumberWithCountryCode phoneNumber,
            GooglePayRequestCard card,
            GooglePayDecryptedTokenData decryptedToken,
            AssuranceDetails assuranceDetails,
            GooglePayExperienceContext experienceContext) {
        this.name = name;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.card = card;
        this.decryptedToken = decryptedToken;
        this.assuranceDetails = assuranceDetails;
        this.experienceContext = experienceContext;
    }

    /**
     * Getter for Name.
     * The full name representation like Mr J Smith.
     * @return Returns the String
     */
    @JsonGetter("name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getName() {
        return name;
    }

    /**
     * Setter for Name.
     * The full name representation like Mr J Smith.
     * @param name Value for String
     */
    @JsonSetter("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @return Returns the String
     */
    @JsonGetter("email_address")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return emailAddress;
    }

    /**
     * Setter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @param emailAddress Value for String
     */
    @JsonSetter("email_address")
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /**
     * Getter for PhoneNumber.
     * The phone number in its canonical international [E.164 numbering plan
     * format](https://www.itu.int/rec/T-REC-E.164/en).
     * @return Returns the PhoneNumberWithCountryCode
     */
    @JsonGetter("phone_number")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PhoneNumberWithCountryCode getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * Setter for PhoneNumber.
     * The phone number in its canonical international [E.164 numbering plan
     * format](https://www.itu.int/rec/T-REC-E.164/en).
     * @param phoneNumber Value for PhoneNumberWithCountryCode
     */
    @JsonSetter("phone_number")
    public void setPhoneNumber(PhoneNumberWithCountryCode phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /**
     * Getter for Card.
     * The payment card used to fund a Google Pay payment. Can be a credit or debit card.
     * @return Returns the GooglePayRequestCard
     */
    @JsonGetter("card")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public GooglePayRequestCard getCard() {
        return card;
    }

    /**
     * Setter for Card.
     * The payment card used to fund a Google Pay payment. Can be a credit or debit card.
     * @param card Value for GooglePayRequestCard
     */
    @JsonSetter("card")
    public void setCard(GooglePayRequestCard card) {
        this.card = card;
    }

    /**
     * Getter for DecryptedToken.
     * Details shared by Google for the merchant to be shared with PayPal. This is required to
     * process the transaction using the Google Pay payment method.
     * @return Returns the GooglePayDecryptedTokenData
     */
    @JsonGetter("decrypted_token")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public GooglePayDecryptedTokenData getDecryptedToken() {
        return decryptedToken;
    }

    /**
     * Setter for DecryptedToken.
     * Details shared by Google for the merchant to be shared with PayPal. This is required to
     * process the transaction using the Google Pay payment method.
     * @param decryptedToken Value for GooglePayDecryptedTokenData
     */
    @JsonSetter("decrypted_token")
    public void setDecryptedToken(GooglePayDecryptedTokenData decryptedToken) {
        this.decryptedToken = decryptedToken;
    }

    /**
     * Getter for AssuranceDetails.
     * Information about cardholder possession validation and cardholder identification and
     * verifications (ID&amp;V).
     * @return Returns the AssuranceDetails
     */
    @JsonGetter("assurance_details")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public AssuranceDetails getAssuranceDetails() {
        return assuranceDetails;
    }

    /**
     * Setter for AssuranceDetails.
     * Information about cardholder possession validation and cardholder identification and
     * verifications (ID&amp;V).
     * @param assuranceDetails Value for AssuranceDetails
     */
    @JsonSetter("assurance_details")
    public void setAssuranceDetails(AssuranceDetails assuranceDetails) {
        this.assuranceDetails = assuranceDetails;
    }

    /**
     * Getter for ExperienceContext.
     * Customizes the payer experience during the approval process for the payment.
     * @return Returns the GooglePayExperienceContext
     */
    @JsonGetter("experience_context")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public GooglePayExperienceContext getExperienceContext() {
        return experienceContext;
    }

    /**
     * Setter for ExperienceContext.
     * Customizes the payer experience during the approval process for the payment.
     * @param experienceContext Value for GooglePayExperienceContext
     */
    @JsonSetter("experience_context")
    public void setExperienceContext(GooglePayExperienceContext experienceContext) {
        this.experienceContext = experienceContext;
    }

    /**
     * Converts this GooglePayRequest into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "GooglePayRequest [" + "name=" + name + ", emailAddress=" + emailAddress
                + ", phoneNumber=" + phoneNumber + ", card=" + card + ", decryptedToken="
                + decryptedToken + ", assuranceDetails=" + assuranceDetails + ", experienceContext="
                + experienceContext + "]";
    }

    /**
     * Builds a new {@link GooglePayRequest.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link GooglePayRequest.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .name(getName())
                .emailAddress(getEmailAddress())
                .phoneNumber(getPhoneNumber())
                .card(getCard())
                .decryptedToken(getDecryptedToken())
                .assuranceDetails(getAssuranceDetails())
                .experienceContext(getExperienceContext());
        return builder;
    }

    /**
     * Class to build instances of {@link GooglePayRequest}.
     */
    public static class Builder {
        private String name;
        private String emailAddress;
        private PhoneNumberWithCountryCode phoneNumber;
        private GooglePayRequestCard card;
        private GooglePayDecryptedTokenData decryptedToken;
        private AssuranceDetails assuranceDetails;
        private GooglePayExperienceContext experienceContext;



        /**
         * Setter for name.
         * @param  name  String value for name.
         * @return Builder
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Setter for emailAddress.
         * @param  emailAddress  String value for emailAddress.
         * @return Builder
         */
        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        /**
         * Setter for phoneNumber.
         * @param  phoneNumber  PhoneNumberWithCountryCode value for phoneNumber.
         * @return Builder
         */
        public Builder phoneNumber(PhoneNumberWithCountryCode phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        /**
         * Setter for card.
         * @param  card  GooglePayRequestCard value for card.
         * @return Builder
         */
        public Builder card(GooglePayRequestCard card) {
            this.card = card;
            return this;
        }

        /**
         * Setter for decryptedToken.
         * @param  decryptedToken  GooglePayDecryptedTokenData value for decryptedToken.
         * @return Builder
         */
        public Builder decryptedToken(GooglePayDecryptedTokenData decryptedToken) {
            this.decryptedToken = decryptedToken;
            return this;
        }

        /**
         * Setter for assuranceDetails.
         * @param  assuranceDetails  AssuranceDetails value for assuranceDetails.
         * @return Builder
         */
        public Builder assuranceDetails(AssuranceDetails assuranceDetails) {
            this.assuranceDetails = assuranceDetails;
            return this;
        }

        /**
         * Setter for experienceContext.
         * @param  experienceContext  GooglePayExperienceContext value for experienceContext.
         * @return Builder
         */
        public Builder experienceContext(GooglePayExperienceContext experienceContext) {
            this.experienceContext = experienceContext;
            return this;
        }

        /**
         * Builds a new {@link GooglePayRequest} object using the set fields.
         * @return {@link GooglePayRequest}
         */
        public GooglePayRequest build() {
            return new GooglePayRequest(name, emailAddress, phoneNumber, card, decryptedToken,
                    assuranceDetails, experienceContext);
        }
    }
}
