/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for GooglePayWalletResponse type.
 */
public class GooglePayWalletResponse {
    private String name;
    private String emailAddress;
    private PhoneNumberWithCountryCode phoneNumber;
    private GooglePayCardResponse card;

    /**
     * Default constructor.
     */
    public GooglePayWalletResponse() {
    }

    /**
     * Initialization constructor.
     * @param  name  String value for name.
     * @param  emailAddress  String value for emailAddress.
     * @param  phoneNumber  PhoneNumberWithCountryCode value for phoneNumber.
     * @param  card  GooglePayCardResponse value for card.
     */
    public GooglePayWalletResponse(
            String name,
            String emailAddress,
            PhoneNumberWithCountryCode phoneNumber,
            GooglePayCardResponse card) {
        this.name = name;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.card = card;
    }

    /**
     * Getter for Name.
     * The full name representation like Mr J Smith.
     * @return Returns the String
     */
    @JsonGetter("name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getName() {
        return name;
    }

    /**
     * Setter for Name.
     * The full name representation like Mr J Smith.
     * @param name Value for String
     */
    @JsonSetter("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @return Returns the String
     */
    @JsonGetter("email_address")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return emailAddress;
    }

    /**
     * Setter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @param emailAddress Value for String
     */
    @JsonSetter("email_address")
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /**
     * Getter for PhoneNumber.
     * The phone number in its canonical international [E.164 numbering plan
     * format](https://www.itu.int/rec/T-REC-E.164/en).
     * @return Returns the PhoneNumberWithCountryCode
     */
    @JsonGetter("phone_number")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PhoneNumberWithCountryCode getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * Setter for PhoneNumber.
     * The phone number in its canonical international [E.164 numbering plan
     * format](https://www.itu.int/rec/T-REC-E.164/en).
     * @param phoneNumber Value for PhoneNumberWithCountryCode
     */
    @JsonSetter("phone_number")
    public void setPhoneNumber(PhoneNumberWithCountryCode phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /**
     * Getter for Card.
     * The payment card to use to fund a Google Pay payment response. Can be a credit or debit card.
     * @return Returns the GooglePayCardResponse
     */
    @JsonGetter("card")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public GooglePayCardResponse getCard() {
        return card;
    }

    /**
     * Setter for Card.
     * The payment card to use to fund a Google Pay payment response. Can be a credit or debit card.
     * @param card Value for GooglePayCardResponse
     */
    @JsonSetter("card")
    public void setCard(GooglePayCardResponse card) {
        this.card = card;
    }

    /**
     * Converts this GooglePayWalletResponse into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "GooglePayWalletResponse [" + "name=" + name + ", emailAddress=" + emailAddress
                + ", phoneNumber=" + phoneNumber + ", card=" + card + "]";
    }

    /**
     * Builds a new {@link GooglePayWalletResponse.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link GooglePayWalletResponse.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .name(getName())
                .emailAddress(getEmailAddress())
                .phoneNumber(getPhoneNumber())
                .card(getCard());
        return builder;
    }

    /**
     * Class to build instances of {@link GooglePayWalletResponse}.
     */
    public static class Builder {
        private String name;
        private String emailAddress;
        private PhoneNumberWithCountryCode phoneNumber;
        private GooglePayCardResponse card;



        /**
         * Setter for name.
         * @param  name  String value for name.
         * @return Builder
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Setter for emailAddress.
         * @param  emailAddress  String value for emailAddress.
         * @return Builder
         */
        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        /**
         * Setter for phoneNumber.
         * @param  phoneNumber  PhoneNumberWithCountryCode value for phoneNumber.
         * @return Builder
         */
        public Builder phoneNumber(PhoneNumberWithCountryCode phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        /**
         * Setter for card.
         * @param  card  GooglePayCardResponse value for card.
         * @return Builder
         */
        public Builder card(GooglePayCardResponse card) {
            this.card = card;
            return this;
        }

        /**
         * Builds a new {@link GooglePayWalletResponse} object using the set fields.
         * @return {@link GooglePayWalletResponse}
         */
        public GooglePayWalletResponse build() {
            return new GooglePayWalletResponse(name, emailAddress, phoneNumber, card);
        }
    }
}
