/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for OrderBillingPlan type.
 */
public class OrderBillingPlan {
    private List<BillingCycle> billingCycles;
    private Money setupFee;
    private String name;

    /**
     * Default constructor.
     */
    public OrderBillingPlan() {
    }

    /**
     * Initialization constructor.
     * @param  billingCycles  List of BillingCycle value for billingCycles.
     * @param  setupFee  Money value for setupFee.
     * @param  name  String value for name.
     */
    public OrderBillingPlan(
            List<BillingCycle> billingCycles,
            Money setupFee,
            String name) {
        this.billingCycles = billingCycles;
        this.setupFee = setupFee;
        this.name = name;
    }

    /**
     * Getter for BillingCycles.
     * An array of billing cycles for trial billing and regular billing. A plan can have at most two
     * trial cycles and only one regular cycle.
     * @return Returns the List of BillingCycle
     */
    @JsonGetter("billing_cycles")
    public List<BillingCycle> getBillingCycles() {
        return billingCycles;
    }

    /**
     * Setter for BillingCycles.
     * An array of billing cycles for trial billing and regular billing. A plan can have at most two
     * trial cycles and only one regular cycle.
     * @param billingCycles Value for List of BillingCycle
     */
    @JsonSetter("billing_cycles")
    public void setBillingCycles(List<BillingCycle> billingCycles) {
        this.billingCycles = billingCycles;
    }

    /**
     * Getter for SetupFee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("setup_fee")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getSetupFee() {
        return setupFee;
    }

    /**
     * Setter for SetupFee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param setupFee Value for Money
     */
    @JsonSetter("setup_fee")
    public void setSetupFee(Money setupFee) {
        this.setupFee = setupFee;
    }

    /**
     * Getter for Name.
     * Name of the recurring plan.
     * @return Returns the String
     */
    @JsonGetter("name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getName() {
        return name;
    }

    /**
     * Setter for Name.
     * Name of the recurring plan.
     * @param name Value for String
     */
    @JsonSetter("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Converts this OrderBillingPlan into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "OrderBillingPlan [" + "billingCycles=" + billingCycles + ", setupFee=" + setupFee
                + ", name=" + name + "]";
    }

    /**
     * Builds a new {@link OrderBillingPlan.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link OrderBillingPlan.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(billingCycles)
                .setupFee(getSetupFee())
                .name(getName());
        return builder;
    }

    /**
     * Class to build instances of {@link OrderBillingPlan}.
     */
    public static class Builder {
        private List<BillingCycle> billingCycles;
        private Money setupFee;
        private String name;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  billingCycles  List of BillingCycle value for billingCycles.
         */
        public Builder(List<BillingCycle> billingCycles) {
            this.billingCycles = billingCycles;
        }

        /**
         * Setter for billingCycles.
         * @param  billingCycles  List of BillingCycle value for billingCycles.
         * @return Builder
         */
        public Builder billingCycles(List<BillingCycle> billingCycles) {
            this.billingCycles = billingCycles;
            return this;
        }

        /**
         * Setter for setupFee.
         * @param  setupFee  Money value for setupFee.
         * @return Builder
         */
        public Builder setupFee(Money setupFee) {
            this.setupFee = setupFee;
            return this;
        }

        /**
         * Setter for name.
         * @param  name  String value for name.
         * @return Builder
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds a new {@link OrderBillingPlan} object using the set fields.
         * @return {@link OrderBillingPlan}
         */
        public OrderBillingPlan build() {
            return new OrderBillingPlan(billingCycles, setupFee, name);
        }
    }
}
