/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * PayeePaymentMethodPreference to be used.
 */
public enum PayeePaymentMethodPreference {
    /**
     * Accepts any type of payment from the customer.
     */
    UNRESTRICTED,

    /**
     * Accepts only immediate payment from the customer. For example, credit card, PayPal balance, or instant ACH. Ensures that at the time of capture, the payment does not have the `pending` status.
     */
    IMMEDIATE_PAYMENT_REQUIRED,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, PayeePaymentMethodPreference> valueMap = new TreeMap<>();
    private String value;

    static {
        UNRESTRICTED.value = "UNRESTRICTED";
        IMMEDIATE_PAYMENT_REQUIRED.value = "IMMEDIATE_PAYMENT_REQUIRED";
        _UNKNOWN.value = null;

        valueMap.put("UNRESTRICTED", UNRESTRICTED);
        valueMap.put("IMMEDIATE_PAYMENT_REQUIRED", IMMEDIATE_PAYMENT_REQUIRED);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static PayeePaymentMethodPreference constructFromString(String toConvert) throws IOException {
        PayeePaymentMethodPreference enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static PayeePaymentMethodPreference fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of PayeePaymentMethodPreference values to list of string values.
     * @param toConvert The list of PayeePaymentMethodPreference values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<PayeePaymentMethodPreference> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (PayeePaymentMethodPreference enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 