/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * PaypalWalletContactPreference to be used.
 */
public enum PaypalWalletContactPreference {
    /**
     * The merchant can opt out of showing buyer's contact information on PayPal checkout.
     */
    NO_CONTACT_INFO,

    /**
     * The merchant allows buyer to add or update shipping contact information on the PayPal checkout. Please ensure to use this updated information returned in shipping.email_address and shipping.phone_number to contact your buyers.
     */
    UPDATE_CONTACT_INFO,

    /**
     * The buyer can only see but can not override merchant passed contact information (shipping.email_address and shipping.phone_number) on PayPal checkout. NOTE: If you don't pass the contact information, the behavior is the same as NO_CONTACT_INFO preference.
     */
    RETAIN_CONTACT_INFO,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, PaypalWalletContactPreference> valueMap = new TreeMap<>();
    private String value;

    static {
        NO_CONTACT_INFO.value = "NO_CONTACT_INFO";
        UPDATE_CONTACT_INFO.value = "UPDATE_CONTACT_INFO";
        RETAIN_CONTACT_INFO.value = "RETAIN_CONTACT_INFO";
        _UNKNOWN.value = null;

        valueMap.put("NO_CONTACT_INFO", NO_CONTACT_INFO);
        valueMap.put("UPDATE_CONTACT_INFO", UPDATE_CONTACT_INFO);
        valueMap.put("RETAIN_CONTACT_INFO", RETAIN_CONTACT_INFO);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static PaypalWalletContactPreference constructFromString(String toConvert) throws IOException {
        PaypalWalletContactPreference enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static PaypalWalletContactPreference fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of PaypalWalletContactPreference values to list of string values.
     * @param toConvert The list of PaypalWalletContactPreference values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<PaypalWalletContactPreference> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (PaypalWalletContactPreference enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 