/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for PaypalWalletStoredCredential type.
 */
public class PaypalWalletStoredCredential {
    private PaymentInitiator paymentInitiator;
    private UsagePattern chargePattern;
    private UsagePattern usagePattern;
    private StoredPaymentSourceUsageType usage;

    /**
     * Default constructor.
     */
    public PaypalWalletStoredCredential() {
        usage = StoredPaymentSourceUsageType.DERIVED;
    }

    /**
     * Initialization constructor.
     * @param  paymentInitiator  PaymentInitiator value for paymentInitiator.
     * @param  chargePattern  UsagePattern value for chargePattern.
     * @param  usagePattern  UsagePattern value for usagePattern.
     * @param  usage  StoredPaymentSourceUsageType value for usage.
     */
    public PaypalWalletStoredCredential(
            PaymentInitiator paymentInitiator,
            UsagePattern chargePattern,
            UsagePattern usagePattern,
            StoredPaymentSourceUsageType usage) {
        this.paymentInitiator = paymentInitiator;
        this.chargePattern = chargePattern;
        this.usagePattern = usagePattern;
        this.usage = usage;
    }

    /**
     * Getter for PaymentInitiator.
     * The person or party who initiated or triggered the payment.
     * @return Returns the PaymentInitiator
     */
    @JsonGetter("payment_initiator")
    public PaymentInitiator getPaymentInitiator() {
        return paymentInitiator;
    }

    /**
     * Setter for PaymentInitiator.
     * The person or party who initiated or triggered the payment.
     * @param paymentInitiator Value for PaymentInitiator
     */
    @JsonSetter("payment_initiator")
    public void setPaymentInitiator(PaymentInitiator paymentInitiator) {
        this.paymentInitiator = paymentInitiator;
    }

    /**
     * Getter for ChargePattern.
     * Expected business/pricing model for the billing agreement.
     * @return Returns the UsagePattern
     */
    @JsonGetter("charge_pattern")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public UsagePattern getChargePattern() {
        return chargePattern;
    }

    /**
     * Setter for ChargePattern.
     * Expected business/pricing model for the billing agreement.
     * @param chargePattern Value for UsagePattern
     */
    @JsonSetter("charge_pattern")
    public void setChargePattern(UsagePattern chargePattern) {
        this.chargePattern = chargePattern;
    }

    /**
     * Getter for UsagePattern.
     * Expected business/pricing model for the billing agreement.
     * @return Returns the UsagePattern
     */
    @JsonGetter("usage_pattern")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public UsagePattern getUsagePattern() {
        return usagePattern;
    }

    /**
     * Setter for UsagePattern.
     * Expected business/pricing model for the billing agreement.
     * @param usagePattern Value for UsagePattern
     */
    @JsonSetter("usage_pattern")
    public void setUsagePattern(UsagePattern usagePattern) {
        this.usagePattern = usagePattern;
    }

    /**
     * Getter for Usage.
     * Indicates if this is a `first` or `subsequent` payment using a stored payment source (also
     * referred to as stored credential or card on file).
     * @return Returns the StoredPaymentSourceUsageType
     */
    @JsonGetter("usage")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public StoredPaymentSourceUsageType getUsage() {
        return usage;
    }

    /**
     * Setter for Usage.
     * Indicates if this is a `first` or `subsequent` payment using a stored payment source (also
     * referred to as stored credential or card on file).
     * @param usage Value for StoredPaymentSourceUsageType
     */
    @JsonSetter("usage")
    public void setUsage(StoredPaymentSourceUsageType usage) {
        this.usage = usage;
    }

    /**
     * Converts this PaypalWalletStoredCredential into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "PaypalWalletStoredCredential [" + "paymentInitiator=" + paymentInitiator
                + ", chargePattern=" + chargePattern + ", usagePattern=" + usagePattern + ", usage="
                + usage + "]";
    }

    /**
     * Builds a new {@link PaypalWalletStoredCredential.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link PaypalWalletStoredCredential.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(paymentInitiator)
                .chargePattern(getChargePattern())
                .usagePattern(getUsagePattern())
                .usage(getUsage());
        return builder;
    }

    /**
     * Class to build instances of {@link PaypalWalletStoredCredential}.
     */
    public static class Builder {
        private PaymentInitiator paymentInitiator;
        private UsagePattern chargePattern;
        private UsagePattern usagePattern;
        private StoredPaymentSourceUsageType usage = StoredPaymentSourceUsageType.DERIVED;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  paymentInitiator  PaymentInitiator value for paymentInitiator.
         */
        public Builder(PaymentInitiator paymentInitiator) {
            this.paymentInitiator = paymentInitiator;
        }

        /**
         * Setter for paymentInitiator.
         * @param  paymentInitiator  PaymentInitiator value for paymentInitiator.
         * @return Builder
         */
        public Builder paymentInitiator(PaymentInitiator paymentInitiator) {
            this.paymentInitiator = paymentInitiator;
            return this;
        }

        /**
         * Setter for chargePattern.
         * @param  chargePattern  UsagePattern value for chargePattern.
         * @return Builder
         */
        public Builder chargePattern(UsagePattern chargePattern) {
            this.chargePattern = chargePattern;
            return this;
        }

        /**
         * Setter for usagePattern.
         * @param  usagePattern  UsagePattern value for usagePattern.
         * @return Builder
         */
        public Builder usagePattern(UsagePattern usagePattern) {
            this.usagePattern = usagePattern;
            return this;
        }

        /**
         * Setter for usage.
         * @param  usage  StoredPaymentSourceUsageType value for usage.
         * @return Builder
         */
        public Builder usage(StoredPaymentSourceUsageType usage) {
            this.usage = usage;
            return this;
        }

        /**
         * Builds a new {@link PaypalWalletStoredCredential} object using the set fields.
         * @return {@link PaypalWalletStoredCredential}
         */
        public PaypalWalletStoredCredential build() {
            return new PaypalWalletStoredCredential(paymentInitiator, chargePattern, usagePattern,
                    usage);
        }
    }
}
