/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for ShippingOption type.
 */
public class ShippingOption {
    private String id;
    private String label;
    private ShippingType type;
    private Money amount;
    private boolean selected;

    /**
     * Default constructor.
     */
    public ShippingOption() {
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  label  String value for label.
     * @param  selected  boolean value for selected.
     * @param  type  ShippingType value for type.
     * @param  amount  Money value for amount.
     */
    public ShippingOption(
            String id,
            String label,
            boolean selected,
            ShippingType type,
            Money amount) {
        this.id = id;
        this.label = label;
        this.type = type;
        this.amount = amount;
        this.selected = selected;
    }

    /**
     * Getter for Id.
     * A unique ID that identifies a payer-selected shipping option.
     * @return Returns the String
     */
    @JsonGetter("id")
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * A unique ID that identifies a payer-selected shipping option.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for Label.
     * A description that the payer sees, which helps them choose an appropriate shipping option.
     * For example, `Free Shipping`, `USPS Priority Shipping`, `Expédition prioritaire USPS`, or
     * `USPS yōuxiān fā huò`. Localize this description to the payer's locale.
     * @return Returns the String
     */
    @JsonGetter("label")
    public String getLabel() {
        return label;
    }

    /**
     * Setter for Label.
     * A description that the payer sees, which helps them choose an appropriate shipping option.
     * For example, `Free Shipping`, `USPS Priority Shipping`, `Expédition prioritaire USPS`, or
     * `USPS yōuxiān fā huò`. Localize this description to the payer's locale.
     * @param label Value for String
     */
    @JsonSetter("label")
    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * Getter for Type.
     * A classification for the method of purchase fulfillment.
     * @return Returns the ShippingType
     */
    @JsonGetter("type")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ShippingType getType() {
        return type;
    }

    /**
     * Setter for Type.
     * A classification for the method of purchase fulfillment.
     * @param type Value for ShippingType
     */
    @JsonSetter("type")
    public void setType(ShippingType type) {
        this.type = type;
    }

    /**
     * Getter for Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("amount")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getAmount() {
        return amount;
    }

    /**
     * Setter for Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param amount Value for Money
     */
    @JsonSetter("amount")
    public void setAmount(Money amount) {
        this.amount = amount;
    }

    /**
     * Getter for Selected.
     * If the API request sets `selected = true`, it represents the shipping option that the payee
     * or merchant expects to be pre-selected for the payer when they first view the
     * `shipping.options` in the PayPal Checkout experience. As part of the response if a
     * `shipping.option` contains `selected=true`, it represents the shipping option that the payer
     * selected during the course of checkout with PayPal. Only one `shipping.option` can be set to
     * `selected=true`.
     * @return Returns the boolean
     */
    @JsonGetter("selected")
    public boolean getSelected() {
        return selected;
    }

    /**
     * Setter for Selected.
     * If the API request sets `selected = true`, it represents the shipping option that the payee
     * or merchant expects to be pre-selected for the payer when they first view the
     * `shipping.options` in the PayPal Checkout experience. As part of the response if a
     * `shipping.option` contains `selected=true`, it represents the shipping option that the payer
     * selected during the course of checkout with PayPal. Only one `shipping.option` can be set to
     * `selected=true`.
     * @param selected Value for boolean
     */
    @JsonSetter("selected")
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    /**
     * Converts this ShippingOption into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "ShippingOption [" + "id=" + id + ", label=" + label + ", selected=" + selected
                + ", type=" + type + ", amount=" + amount + "]";
    }

    /**
     * Builds a new {@link ShippingOption.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link ShippingOption.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(id, label, selected)
                .type(getType())
                .amount(getAmount());
        return builder;
    }

    /**
     * Class to build instances of {@link ShippingOption}.
     */
    public static class Builder {
        private String id;
        private String label;
        private boolean selected;
        private ShippingType type;
        private Money amount;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  id  String value for id.
         * @param  label  String value for label.
         * @param  selected  boolean value for selected.
         */
        public Builder(String id, String label, boolean selected) {
            this.id = id;
            this.label = label;
            this.selected = selected;
        }

        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for label.
         * @param  label  String value for label.
         * @return Builder
         */
        public Builder label(String label) {
            this.label = label;
            return this;
        }

        /**
         * Setter for selected.
         * @param  selected  boolean value for selected.
         * @return Builder
         */
        public Builder selected(boolean selected) {
            this.selected = selected;
            return this;
        }

        /**
         * Setter for type.
         * @param  type  ShippingType value for type.
         * @return Builder
         */
        public Builder type(ShippingType type) {
            this.type = type;
            return this;
        }

        /**
         * Setter for amount.
         * @param  amount  Money value for amount.
         * @return Builder
         */
        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Builds a new {@link ShippingOption} object using the set fields.
         * @return {@link ShippingOption}
         */
        public ShippingOption build() {
            return new ShippingOption(id, label, selected, type, amount);
        }
    }
}
