/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for StoredPaymentSource type.
 */
public class StoredPaymentSource {
    private PaymentInitiator paymentInitiator;
    private StoredPaymentSourcePaymentType paymentType;
    private StoredPaymentSourceUsageType usage;
    private NetworkTransactionReference previousNetworkTransactionReference;

    /**
     * Default constructor.
     */
    public StoredPaymentSource() {
        usage = StoredPaymentSourceUsageType.DERIVED;
    }

    /**
     * Initialization constructor.
     * @param  paymentInitiator  PaymentInitiator value for paymentInitiator.
     * @param  paymentType  StoredPaymentSourcePaymentType value for paymentType.
     * @param  usage  StoredPaymentSourceUsageType value for usage.
     * @param  previousNetworkTransactionReference  NetworkTransactionReference value for
     *         previousNetworkTransactionReference.
     */
    public StoredPaymentSource(
            PaymentInitiator paymentInitiator,
            StoredPaymentSourcePaymentType paymentType,
            StoredPaymentSourceUsageType usage,
            NetworkTransactionReference previousNetworkTransactionReference) {
        this.paymentInitiator = paymentInitiator;
        this.paymentType = paymentType;
        this.usage = usage;
        this.previousNetworkTransactionReference = previousNetworkTransactionReference;
    }

    /**
     * Getter for PaymentInitiator.
     * The person or party who initiated or triggered the payment.
     * @return Returns the PaymentInitiator
     */
    @JsonGetter("payment_initiator")
    public PaymentInitiator getPaymentInitiator() {
        return paymentInitiator;
    }

    /**
     * Setter for PaymentInitiator.
     * The person or party who initiated or triggered the payment.
     * @param paymentInitiator Value for PaymentInitiator
     */
    @JsonSetter("payment_initiator")
    public void setPaymentInitiator(PaymentInitiator paymentInitiator) {
        this.paymentInitiator = paymentInitiator;
    }

    /**
     * Getter for PaymentType.
     * Indicates the type of the stored payment_source payment.
     * @return Returns the StoredPaymentSourcePaymentType
     */
    @JsonGetter("payment_type")
    public StoredPaymentSourcePaymentType getPaymentType() {
        return paymentType;
    }

    /**
     * Setter for PaymentType.
     * Indicates the type of the stored payment_source payment.
     * @param paymentType Value for StoredPaymentSourcePaymentType
     */
    @JsonSetter("payment_type")
    public void setPaymentType(StoredPaymentSourcePaymentType paymentType) {
        this.paymentType = paymentType;
    }

    /**
     * Getter for Usage.
     * Indicates if this is a `first` or `subsequent` payment using a stored payment source (also
     * referred to as stored credential or card on file).
     * @return Returns the StoredPaymentSourceUsageType
     */
    @JsonGetter("usage")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public StoredPaymentSourceUsageType getUsage() {
        return usage;
    }

    /**
     * Setter for Usage.
     * Indicates if this is a `first` or `subsequent` payment using a stored payment source (also
     * referred to as stored credential or card on file).
     * @param usage Value for StoredPaymentSourceUsageType
     */
    @JsonSetter("usage")
    public void setUsage(StoredPaymentSourceUsageType usage) {
        this.usage = usage;
    }

    /**
     * Getter for PreviousNetworkTransactionReference.
     * Reference values used by the card network to identify a transaction.
     * @return Returns the NetworkTransactionReference
     */
    @JsonGetter("previous_network_transaction_reference")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public NetworkTransactionReference getPreviousNetworkTransactionReference() {
        return previousNetworkTransactionReference;
    }

    /**
     * Setter for PreviousNetworkTransactionReference.
     * Reference values used by the card network to identify a transaction.
     * @param previousNetworkTransactionReference Value for NetworkTransactionReference
     */
    @JsonSetter("previous_network_transaction_reference")
    public void setPreviousNetworkTransactionReference(NetworkTransactionReference previousNetworkTransactionReference) {
        this.previousNetworkTransactionReference = previousNetworkTransactionReference;
    }

    /**
     * Converts this StoredPaymentSource into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "StoredPaymentSource [" + "paymentInitiator=" + paymentInitiator + ", paymentType="
                + paymentType + ", usage=" + usage + ", previousNetworkTransactionReference="
                + previousNetworkTransactionReference + "]";
    }

    /**
     * Builds a new {@link StoredPaymentSource.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link StoredPaymentSource.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(paymentInitiator, paymentType)
                .usage(getUsage())
                .previousNetworkTransactionReference(getPreviousNetworkTransactionReference());
        return builder;
    }

    /**
     * Class to build instances of {@link StoredPaymentSource}.
     */
    public static class Builder {
        private PaymentInitiator paymentInitiator;
        private StoredPaymentSourcePaymentType paymentType;
        private StoredPaymentSourceUsageType usage = StoredPaymentSourceUsageType.DERIVED;
        private NetworkTransactionReference previousNetworkTransactionReference;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  paymentInitiator  PaymentInitiator value for paymentInitiator.
         * @param  paymentType  StoredPaymentSourcePaymentType value for paymentType.
         */
        public Builder(PaymentInitiator paymentInitiator,
                StoredPaymentSourcePaymentType paymentType) {
            this.paymentInitiator = paymentInitiator;
            this.paymentType = paymentType;
        }

        /**
         * Setter for paymentInitiator.
         * @param  paymentInitiator  PaymentInitiator value for paymentInitiator.
         * @return Builder
         */
        public Builder paymentInitiator(PaymentInitiator paymentInitiator) {
            this.paymentInitiator = paymentInitiator;
            return this;
        }

        /**
         * Setter for paymentType.
         * @param  paymentType  StoredPaymentSourcePaymentType value for paymentType.
         * @return Builder
         */
        public Builder paymentType(StoredPaymentSourcePaymentType paymentType) {
            this.paymentType = paymentType;
            return this;
        }

        /**
         * Setter for usage.
         * @param  usage  StoredPaymentSourceUsageType value for usage.
         * @return Builder
         */
        public Builder usage(StoredPaymentSourceUsageType usage) {
            this.usage = usage;
            return this;
        }

        /**
         * Setter for previousNetworkTransactionReference.
         * @param  previousNetworkTransactionReference  NetworkTransactionReference value for
         *         previousNetworkTransactionReference.
         * @return Builder
         */
        public Builder previousNetworkTransactionReference(
                NetworkTransactionReference previousNetworkTransactionReference) {
            this.previousNetworkTransactionReference = previousNetworkTransactionReference;
            return this;
        }

        /**
         * Builds a new {@link StoredPaymentSource} object using the set fields.
         * @return {@link StoredPaymentSource}
         */
        public StoredPaymentSource build() {
            return new StoredPaymentSource(paymentInitiator, paymentType, usage,
                    previousNetworkTransactionReference);
        }
    }
}
