/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * VenmoPaymentTokenUsagePattern to be used.
 */
public enum VenmoPaymentTokenUsagePattern {
    /**
     * On-demand instant payments – non-recurring, pre-paid, variable amount, variable frequency.
     */
    IMMEDIATE,

    /**
     * Pay after use, non-recurring post-paid, variable amount, irregular frequency.
     */
    DEFERRED,

    /**
     * Pay upfront fixed or variable amount on a fixed date before the goods/service is delivered.
     */
    RECURRING_PREPAID,

    /**
     * Pay on a fixed date based on usage or consumption after the goods/service is delivered.
     */
    RECURRING_POSTPAID,

    /**
     * Charge payer when the set amount is reached or monthly billing cycle, whichever comes first, before the goods/service is delivered.
     */
    THRESHOLD_PREPAID,

    /**
     * Charge payer when the set amount is reached or monthly billing cycle, whichever comes first, after the goods/service is delivered.
     */
    THRESHOLD_POSTPAID,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, VenmoPaymentTokenUsagePattern> valueMap = new TreeMap<>();
    private String value;

    static {
        IMMEDIATE.value = "IMMEDIATE";
        DEFERRED.value = "DEFERRED";
        RECURRING_PREPAID.value = "RECURRING_PREPAID";
        RECURRING_POSTPAID.value = "RECURRING_POSTPAID";
        THRESHOLD_PREPAID.value = "THRESHOLD_PREPAID";
        THRESHOLD_POSTPAID.value = "THRESHOLD_POSTPAID";
        _UNKNOWN.value = null;

        valueMap.put("IMMEDIATE", IMMEDIATE);
        valueMap.put("DEFERRED", DEFERRED);
        valueMap.put("RECURRING_PREPAID", RECURRING_PREPAID);
        valueMap.put("RECURRING_POSTPAID", RECURRING_POSTPAID);
        valueMap.put("THRESHOLD_PREPAID", THRESHOLD_PREPAID);
        valueMap.put("THRESHOLD_POSTPAID", THRESHOLD_POSTPAID);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static VenmoPaymentTokenUsagePattern constructFromString(String toConvert) throws IOException {
        VenmoPaymentTokenUsagePattern enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static VenmoPaymentTokenUsagePattern fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of VenmoPaymentTokenUsagePattern values to list of string values.
     * @param toConvert The list of VenmoPaymentTokenUsagePattern values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<VenmoPaymentTokenUsagePattern> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (VenmoPaymentTokenUsagePattern enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 