/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.google.common.collect.ImmutableList;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.gui.BaseCellEditor;
import com.puppycrawl.tools.checkstyle.gui.CodeSelector;
import com.puppycrawl.tools.checkstyle.gui.ListToTreeSelectionModelWrapper;
import com.puppycrawl.tools.checkstyle.gui.ParseTreeTableModel;
import com.puppycrawl.tools.checkstyle.gui.TreeTableCellRenderer;
import com.puppycrawl.tools.checkstyle.gui.TreeTableModelAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    private static final long serialVersionUID = -8493693409423365387L;
    private final TreeTableCellRenderer tree;
    private JTextArea editor;
    private List<Integer> linePositionMap;

    public JTreeTable(ParseTreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(this, treeTableModel);
        this.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper(this);
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(ParseTreeTableModel.class, this.tree);
        this.setDefaultEditor(ParseTreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(this.getRowHeight());
        }
        AbstractAction expand = new AbstractAction(){
            private static final long serialVersionUID = -5859674518660156121L;

            @Override
            public void actionPerformed(ActionEvent event) {
                TreePath selected = JTreeTable.this.tree.getSelectionPath();
                DetailAST ast = (DetailAST)((Object)selected.getLastPathComponent());
                new CodeSelector(ast, JTreeTable.this.editor, JTreeTable.this.linePositionMap).select();
                if (JTreeTable.this.tree.isExpanded(selected)) {
                    JTreeTable.this.tree.collapsePath(selected);
                } else {
                    JTreeTable.this.tree.expandPath(selected);
                }
                JTreeTable.this.tree.setSelectionPath(selected);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke("ENTER");
        String command = "expand/collapse";
        this.getInputMap().put(stroke, "expand/collapse");
        this.getActionMap().put("expand/collapse", expand);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        Class<?> editingClass = this.getColumnClass(this.editingColumn);
        if (editingClass == ParseTreeTableModel.class) {
            return -1;
        }
        return this.editingRow;
    }

    @Override
    public final void setRowHeight(int newRowHeight) {
        super.setRowHeight(newRowHeight);
        if (this.tree != null && this.tree.getRowHeight() != newRowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setEditor(JTextArea textArea) {
        this.editor = textArea;
    }

    public void setLinePositionMap(List<Integer> linePositionMap) {
        this.linePositionMap = ImmutableList.copyOf(linePositionMap);
    }

    private class TreeTableCellEditor
    extends BaseCellEditor
    implements TableCellEditor {
        private TreeTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return JTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            if (event instanceof MouseEvent) {
                for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (JTreeTable.this.getColumnClass(counter) != ParseTreeTableModel.class) continue;
                    MouseEvent mouseEvent = (MouseEvent)event;
                    MouseEvent newMouseEvent = new MouseEvent(JTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(newMouseEvent);
                    break;
                }
            }
            return false;
        }
    }
}

