/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.track;

import android.content.Context;
import com.tencent.beacon.event.open.BeaconConfig;
import com.tencent.beacon.event.open.BeaconEvent;
import com.tencent.beacon.event.open.BeaconReport;
import com.tencent.beacon.event.open.EventResult;
import com.tencent.beacon.event.open.EventType;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qimei.sdk.IQimeiSDK;
import com.tencent.qimei.sdk.QimeiSDK;
import java.util.Map;

public class TrackService {
    private static final String TAG = "TrackService";
    private static String beaconKey;
    private static boolean debug;
    private static boolean isCloseBeacon;
    private Context context;
    private static TrackService instance;

    private TrackService(Context context) {
        this.context = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context, String beaconKey, boolean debug, boolean isCloseBeacon) {
        Class<TrackService> clazz = TrackService.class;
        synchronized (TrackService.class) {
            if (instance == null) {
                instance = new TrackService(context);
                TrackService.beaconKey = beaconKey;
                TrackService.debug = debug;
                TrackService.isCloseBeacon = isCloseBeacon;
                if (!TrackService.isCloseBeacon && TrackService.isIncludeBeacon()) {
                    BeaconConfig.Builder builder = BeaconConfig.builder().auditEnable(false).bidEnable(false).qmspEnable(false).pagePathEnable(false).setNormalPollingTime(30000L);
                    BeaconConfig config = builder.build();
                    BeaconReport beaconReport = BeaconReport.getInstance();
                    beaconReport.setLogAble(debug);
                    try {
                        beaconReport.setCollectProcessInfo(false);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    try {
                        IQimeiSDK qimeiSDK = QimeiSDK.getInstance((String)beaconKey);
                        qimeiSDK.getStrategy().enableOAID(false).enableIMEI(false).enableIMSI(false).enableAndroidId(false).enableMAC(false).enableCid(false).enableProcessInfo(false).enableBuildModel(false);
                        beaconReport.start(context, beaconKey, config);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        beaconReport.setCollectProcessInfo(false);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public static TrackService getInstance() {
        return instance;
    }

    public void track(String beaconKey, String eventCode, Map<String, String> params) {
        if (isCloseBeacon || !TrackService.isIncludeBeacon()) {
            return;
        }
        String trackBeaconKey = TrackService.beaconKey;
        if (beaconKey != null) {
            trackBeaconKey = beaconKey;
        }
        BeaconEvent.Builder builder = BeaconEvent.builder().withAppKey(trackBeaconKey).withCode(eventCode).withType(EventType.NORMAL).withParams(params);
        EventResult result = BeaconReport.getInstance().report(builder.build());
        if (debug) {
            StringBuilder mapAsString = new StringBuilder("{");
            for (String key : params.keySet()) {
                mapAsString.append(key + "=" + params.get(key) + ", ");
            }
            mapAsString.delete(mapAsString.length() - 2, mapAsString.length()).append("}");
            QCloudLogger.i(TAG, "eventCode: %s, params: %s => result{ eventID: %s, errorCode: %d, errorMsg: %s}", eventCode, mapAsString, result.eventID, result.errorCode, result.errMsg);
        }
    }

    public static boolean isIncludeBeacon() {
        try {
            Class.forName("com.tencent.beacon.event.open.BeaconReport");
            Class.forName("com.tencent.qimei.sdk.QimeiSDK");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        debug = false;
        isCloseBeacon = false;
    }
}

