/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.internal.AbstractCosResponseHandler;
import com.qcloud.cos.internal.CosServiceResponse;
import com.qcloud.cos.internal.Unmarshaller;
import com.qcloud.cos.model.BucketDomainConfiguration;
import com.qcloud.cos.model.CiServiceResult;
import com.qcloud.cos.model.CosServiceResult;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COSXmlResponseHandler<T>
extends AbstractCosResponseHandler<T> {
    private Unmarshaller<T, InputStream> responseUnmarshaller;
    private static final Logger log = LoggerFactory.getLogger(COSXmlResponseHandler.class);
    private Map<String, String> responseHeaders;

    public COSXmlResponseHandler(Unmarshaller<T, InputStream> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
    }

    @Override
    public CosServiceResponse<T> handle(CosHttpResponse response) throws Exception {
        CosServiceResponse<T> cosResponse = this.parseResponseMetadata(response);
        this.responseHeaders = response.getHeaders();
        if (this.responseUnmarshaller != null) {
            log.trace("Beginning to parse service response XML");
            T result = this.responseUnmarshaller.unmarshall(response.getContent());
            if (result instanceof BucketDomainConfiguration && this.responseHeaders.containsKey("x-cos-domain-txt-verification")) {
                ((BucketDomainConfiguration)result).setDomainTxtVerification(this.responseHeaders.get("x-cos-domain-txt-verification"));
            }
            log.trace("Done parsing service response XML");
            cosResponse.setResult(result);
        }
        if (cosResponse.getResult() != null && cosResponse.getResult() instanceof CosServiceResult) {
            ((CosServiceResult)cosResponse.getResult()).setRequestId(this.responseHeaders.get("x-cos-request-id"));
        }
        if (cosResponse.getResult() != null && cosResponse.getResult() instanceof CiServiceResult) {
            ((CiServiceResult)cosResponse.getResult()).setRequestId(this.responseHeaders.get("x-ci-request-id"));
        }
        return cosResponse;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }
}

