/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.COSEncryption;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.internal.COSDirect;
import com.qcloud.cos.internal.crypto.COSCryptoModule;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoModuleDispatcher;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsProvider;
import com.qcloud.cos.internal.crypto.QCLOUDKMS;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectId;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyPartResult;
import com.qcloud.cos.model.DeleteObjectRequest;
import com.qcloud.cos.model.EncryptedInitiateMultipartUploadRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.InstructionFileId;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutInstructionFileRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import java.io.File;

public class COSEncryptionClient
extends COSClient
implements COSEncryption {
    private final COSCryptoModule crypto;
    private final boolean isKMSClientInternal;

    public COSEncryptionClient(COSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, ClientConfig clientConfig, CryptoConfiguration cryptoConfig) {
        this(null, credentialsProvider, kekMaterialsProvider, clientConfig, cryptoConfig);
    }

    public COSEncryptionClient(QCLOUDKMS kms, COSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, ClientConfig clientConfig, CryptoConfiguration cryptoConfig) {
        super(credentialsProvider.getCredentials(), clientConfig);
        this.assertParameterNotNull(kekMaterialsProvider, "EncryptionMaterialsProvider parameter must not be null.");
        this.assertParameterNotNull(cryptoConfig, "CryptoConfiguration parameter must not be null.");
        this.isKMSClientInternal = kms == null;
        this.crypto = new CryptoModuleDispatcher(kms, new COSDirectImpl(), credentialsProvider, kekMaterialsProvider, cryptoConfig);
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest req) {
        return this.crypto.putObjectSecurely(req.clone());
    }

    @Override
    public COSObject getObject(GetObjectRequest req) {
        return this.crypto.getObjectSecurely(req);
    }

    @Override
    public ObjectMetadata getObject(GetObjectRequest req, File dest) {
        return this.crypto.getObjectSecurely(req, dest);
    }

    @Override
    public void deleteObject(DeleteObjectRequest req) {
        super.deleteObject(req);
        InstructionFileId ifid = new COSObjectId(req.getBucketName(), req.getKey()).instructionFileId();
        DeleteObjectRequest instructionDeleteRequest = (DeleteObjectRequest)req.clone();
        instructionDeleteRequest.withBucketName(ifid.getBucket()).withKey(ifid.getKey());
        super.deleteObject(instructionDeleteRequest);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest req) {
        return this.crypto.completeMultipartUploadSecurely(req);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest req) {
        boolean isCreateEncryptionMaterial = true;
        if (req instanceof EncryptedInitiateMultipartUploadRequest) {
            EncryptedInitiateMultipartUploadRequest cryptoReq = (EncryptedInitiateMultipartUploadRequest)req;
            isCreateEncryptionMaterial = cryptoReq.isCreateEncryptionMaterial();
        }
        return isCreateEncryptionMaterial ? this.crypto.initiateMultipartUploadSecurely(req) : super.initiateMultipartUpload(req);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws CosClientException, CosServiceException {
        return this.crypto.uploadPartSecurely(uploadPartRequest);
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
        return this.crypto.copyPartSecurely(copyPartRequest);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest req) {
        this.crypto.abortMultipartUploadSecurely(req);
    }

    public PutObjectResult putInstructionFile(PutInstructionFileRequest req) {
        return this.crypto.putInstructionFileSecurely(req);
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    private final class COSDirectImpl
    extends COSDirect {
        private COSDirectImpl() {
        }

        @Override
        public PutObjectResult putObject(PutObjectRequest req) {
            return COSEncryptionClient.super.putObject(req);
        }

        @Override
        public COSObject getObject(GetObjectRequest req) {
            return COSEncryptionClient.super.getObject(req);
        }

        @Override
        public ObjectMetadata getObject(GetObjectRequest req, File dest) {
            return COSEncryptionClient.super.getObject(req, dest);
        }

        @Override
        public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest req) {
            return COSEncryptionClient.super.completeMultipartUpload(req);
        }

        @Override
        public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest req) {
            return COSEncryptionClient.super.initiateMultipartUpload(req);
        }

        @Override
        public UploadPartResult uploadPart(UploadPartRequest req) throws CosClientException, CosServiceException {
            return COSEncryptionClient.super.uploadPart(req);
        }

        @Override
        public CopyPartResult copyPart(CopyPartRequest req) {
            return COSEncryptionClient.super.copyPart(req);
        }

        @Override
        public void abortMultipartUpload(AbortMultipartUploadRequest req) {
            COSEncryptionClient.super.abortMultipartUpload(req);
        }
    }
}

