/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims.database;

import com.redhat.victims.VictimsConfig;
import com.redhat.victims.VictimsException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;

public class VictimsSQL {
    private String dbDriver = null;
    private String dbUrl = null;
    private String dbUser = null;
    private String dbPass = null;

    protected Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPass);
    }

    protected boolean isSetUp(Connection connection) throws SQLException {
        boolean result = false;
        DatabaseMetaData dbm = connection.getMetaData();
        ResultSet rs = dbm.getTables(null, null, "RECORDS", null);
        result = rs.next();
        rs.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws SQLException {
        Connection connection = this.getConnection();
        try {
            if (!this.isSetUp(connection)) {
                Statement stmt = connection.createStatement();
                stmt.execute("CREATE TABLE records ( id BIGINT PRIMARY KEY AUTO_INCREMENT, hash VARCHAR(128))");
                stmt.execute("CREATE TABLE filehashes (record BIGINT, filehash VARCHAR(128), FOREIGN KEY(record) REFERENCES records(id) ON DELETE CASCADE)");
                stmt.execute("CREATE TABLE meta (record BIGINT, prop VARCHAR(255), value VARCHAR(255), FOREIGN KEY(record) REFERENCES records(id) ON DELETE CASCADE)");
                stmt.execute("CREATE TABLE cves (record BIGINT, cve VARCHAR(32), FOREIGN KEY(record) REFERENCES records(id) ON DELETE CASCADE)");
                stmt.close();
            }
        }
        finally {
            connection.close();
        }
    }

    public VictimsSQL() throws VictimsException {
        try {
            this.dbDriver = VictimsConfig.dbDriver();
            this.dbUrl = VictimsConfig.dbUrl();
            this.dbUser = VictimsConfig.dbUser();
            this.dbPass = VictimsConfig.dbPass();
            Class.forName(this.dbDriver);
            this.setUp();
        }
        catch (Throwable t) {
            throw new VictimsException("Could not create a VictimsSQL instance.", t);
        }
    }

    protected PreparedStatement statement(Connection connection, String query) throws SQLException {
        return connection.prepareStatement(query);
    }

    protected PreparedStatement setObjects(Connection connection, String query, Object ... objects) throws SQLException {
        PreparedStatement ps = this.statement(connection, query);
        this.setObjects(ps, objects);
        return ps;
    }

    protected void setObjects(PreparedStatement ps, Object ... objects) throws SQLException {
        int index = 1;
        for (Object obj : objects) {
            ps.setObject(index, obj);
            ++index;
        }
    }

    protected void executeBatchAndClose(PreparedStatement ... preparedStatements) throws SQLException {
        for (PreparedStatement ps : preparedStatements) {
            ps.executeBatch();
            ps.clearBatch();
            ps.close();
        }
    }

    protected String constructInStringsQuery(String query, Set<String> values) {
        String replace = "IN (?)";
        assert (query.lastIndexOf(replace) == query.indexOf(replace));
        String sql = query.replace("IN (?)", "IN (%s)");
        StringBuffer list = new StringBuffer();
        for (String value : values) {
            if (list.length() > 0) {
                list.append(",");
            }
            value = String.format("'%s'", StringEscapeUtils.escapeSql((String)value));
            list.append(value);
        }
        return String.format(sql, list.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int selectRecordId(String hash) throws SQLException {
        int id = -1;
        Connection connection = this.getConnection();
        try {
            PreparedStatement ps = this.setObjects(connection, "SELECT id FROM records WHERE hash = ?", hash);
            ResultSet rs = ps.executeQuery();
            try {
                if (rs.next()) {
                    id = rs.getInt("id");
                }
            }
            finally {
                rs.close();
                ps.close();
            }
        }
        finally {
            connection.close();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insertRecord(Connection connection, String hash) throws SQLException {
        int id = -1;
        PreparedStatement ps = this.setObjects(connection, "INSERT INTO records (hash) VALUES (?)", hash);
        ps.execute();
        ResultSet rs = ps.getGeneratedKeys();
        try {
            if (rs.next()) {
                id = rs.getInt(1);
            }
        }
        finally {
            rs.close();
            ps.close();
        }
        return id;
    }

    protected void deleteRecord(Connection connection, String hash) throws SQLException {
        int id = this.selectRecordId(hash);
        if (id > 0) {
            String[] queries;
            for (String query : queries = new String[]{"DELETE FROM filehashes WHERE record = ?", "DELETE FROM meta WHERE record = ?", "DELETE FROM cves WHERE record = ?", "DELETE FROM records WHERE id = ?"}) {
                PreparedStatement ps = this.setObjects(connection, query, id);
                ps.execute();
                ps.close();
            }
        }
    }

    protected static class Query {
        protected static final String CREATE_TABLE_RECORDS = "CREATE TABLE records ( id BIGINT PRIMARY KEY AUTO_INCREMENT, hash VARCHAR(128))";
        protected static final String CREATE_TABLE_FILEHASHES = "CREATE TABLE filehashes (record BIGINT, filehash VARCHAR(128), FOREIGN KEY(record) REFERENCES records(id) ON DELETE CASCADE)";
        protected static final String CREATE_TABLE_META = "CREATE TABLE meta (record BIGINT, prop VARCHAR(255), value VARCHAR(255), FOREIGN KEY(record) REFERENCES records(id) ON DELETE CASCADE)";
        protected static final String CREATE_TABLE_CVES = "CREATE TABLE cves (record BIGINT, cve VARCHAR(32), FOREIGN KEY(record) REFERENCES records(id) ON DELETE CASCADE)";
        protected static final String INSERT_FILEHASH = "INSERT INTO filehashes (record, filehash) VALUES (?, ?)";
        protected static final String INSERT_META = "INSERT INTO meta (record, prop, value) VALUES (?, ?, ?)";
        protected static final String INSERT_CVES = "INSERT INTO cves (record, cve) VALUES (?, ?)";
        protected static final String INSERT_RECORD = "INSERT INTO records (hash) VALUES (?)";
        protected static final String GET_RECORD_ID = "SELECT id FROM records WHERE hash = ?";
        protected static final String FIND_CVES = "SELECT cve FROM cves WHERE record = ?";
        protected static final String DELETE_RECORD_HASH = "DELETE FROM records WHERE hash = ?";
        protected static final String DELETE_RECORD_ID = "DELETE FROM records WHERE id = ?";
        protected static final String DELETE_FILEHASHES = "DELETE FROM filehashes WHERE record = ?";
        protected static final String DELETE_METAS = "DELETE FROM meta WHERE record = ?";
        protected static final String DELETE_CVES = "DELETE FROM cves WHERE record = ?";
        protected static final String FILEHASH_MATCHES_PER_RECORD = "SELECT record, count(filehash) FROM filehashes WHERE filehash IN (?) GROUP BY record";
        protected static final String FILEHASH_COUNT_PER_RECORD = "SELECT record, count(*) FROM filehashes GROUP BY record";
        protected static final String FILEHASHES = "SELECT record, filehash FROM filehashes";
        protected static final String PROPERTY_MATCH = "SELECT record FROM meta WHERE prop = ? AND value = ?";
        protected static final String RECORD_COUNT = "SELECT COUNT(*) from records";

        protected Query() {
        }
    }
}

