/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims.fingerprint;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Metadata
extends HashMap<String, String> {
    public static Metadata fromPomProperties(InputStream is) {
        Metadata metadata = new Metadata();
        BufferedReader input = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = input.readLine()) != null) {
                String[] property;
                if (line.startsWith("#") || (property = line.trim().split("=")).length != 2) continue;
                metadata.put(property[0], property[1]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return metadata;
    }

    public static Metadata fromManifest(InputStream is) {
        try {
            Manifest mf = new Manifest(is);
            return Metadata.fromManifest(mf);
        }
        catch (IOException iOException) {
            return new Metadata();
        }
    }

    public static Metadata fromManifest(Manifest mf) {
        Attributes.Name[] attribs;
        Metadata metadata = new Metadata();
        for (Attributes.Name attrib : attribs = new Attributes.Name[]{Attributes.Name.MANIFEST_VERSION, Attributes.Name.IMPLEMENTATION_TITLE, Attributes.Name.IMPLEMENTATION_URL, Attributes.Name.IMPLEMENTATION_VENDOR, Attributes.Name.IMPLEMENTATION_VENDOR_ID, Attributes.Name.IMPLEMENTATION_VERSION, Attributes.Name.MAIN_CLASS}) {
            Object o = mf.getMainAttributes().get(attrib);
            if (o == null) continue;
            metadata.put(attrib.toString(), o.toString());
        }
        return metadata;
    }
}

